/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

@Restricted(value={NoExternalUse.class})
public class McpConnectionMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpConnectionMetrics.class);
    public static final String URL_NAME = "mcp-server/metrics";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final AtomicLong sseConnectionsTotal = new AtomicLong(0L);
    private static final AtomicLong sseConnectionsActive = new AtomicLong(0L);
    private static final AtomicLong streamableRequestsTotal = new AtomicLong(0L);
    private static final AtomicLong connectionErrorsTotal = new AtomicLong(0L);
    private static final Instant startTime = Instant.now();

    public static void handleMetricsRequest(HttpServletResponse response) throws IOException {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && jenkins.isUseSecurity()) {
            try {
                jenkins.checkPermission(Jenkins.READ);
            }
            catch (AccessDeniedException e) {
                response.sendError(403, "Authentication required");
                return;
            }
        }
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        ObjectNode responseJson = objectMapper.createObjectNode();
        responseJson.put("sseConnectionsTotal", sseConnectionsTotal.get());
        responseJson.put("sseConnectionsActive", sseConnectionsActive.get());
        responseJson.put("streamableRequestsTotal", streamableRequestsTotal.get());
        responseJson.put("connectionErrorsTotal", connectionErrorsTotal.get());
        Duration uptime = Duration.between(startTime, Instant.now());
        responseJson.put("uptimeSeconds", uptime.getSeconds());
        responseJson.put("startTime", startTime.toString());
        response.getWriter().write(objectMapper.writeValueAsString((Object)responseJson));
        response.getWriter().flush();
    }

    public static void recordSseConnectionStart() {
        sseConnectionsTotal.incrementAndGet();
        sseConnectionsActive.incrementAndGet();
    }

    public static void recordSseConnectionEnd() {
        sseConnectionsActive.decrementAndGet();
    }

    public static void recordStreamableRequest() {
        streamableRequestsTotal.incrementAndGet();
    }

    public static void recordConnectionError() {
        connectionErrorsTotal.incrementAndGet();
    }

    public static long getActiveSseConnections() {
        return sseConnectionsActive.get();
    }

    public static long getTotalSseConnections() {
        return sseConnectionsTotal.get();
    }

    public static long getTotalStreamableRequests() {
        return streamableRequestsTotal.get();
    }

    public static long getTotalConnectionErrors() {
        return connectionErrorsTotal.get();
    }

    static void reset() {
        sseConnectionsTotal.set(0L);
        sseConnectionsActive.set(0L);
        streamableRequestsTotal.set(0L);
        connectionErrorsTotal.set(0L);
    }
}

