/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.Property;
import org.kohsuke.stapler.export.TreePruner;

public class JenkinsExportedBeanSerializer
extends JsonSerializer<Object> {
    private static final ModelBuilder MODEL_BUILDER = new ModelBuilder();
    private static final List<String> EXCLUDED_PROPERTIES = List.of("enclosingBlocks", "nodeId");
    private static final TreePruner CLEANER_PRUNER = new TreePruner(){

        public TreePruner accept(Object node, Property prop) {
            return EXCLUDED_PROPERTIES.contains(prop.name) ? null : TreePruner.DEFAULT;
        }
    };

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        StringWriter sw = new StringWriter();
        DataWriter dw = Flavor.JSON.createDataWriter(value, (Writer)sw);
        Model p = MODEL_BUILDER.get(value.getClass());
        p.writeTo(value, CLEANER_PRUNER, dw);
        gen.writeRawValue(sw.toString());
    }
}

