/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.tool.McpToolWrapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.json.schema.jackson.DefaultJsonSchemaValidator;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpTransportContextExtractor;
import io.modelcontextprotocol.server.transport.HttpServletSseServerTransportProvider;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.util.HttpServletFilter;
import jenkins.util.SystemProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
@Extension
public class Endpoint
extends CrumbExclusion
implements RootAction,
HttpServletFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Endpoint.class);
    public static final String MCP_SERVER = "mcp-server";
    public static final String SSE_ENDPOINT = "/sse";
    public static final String MCP_SERVER_SSE = "mcp-server/sse";
    public static final String STREAMABLE_ENDPOINT = "/mcp";
    public static final String MCP_SERVER_STREAMABLE = "mcp-server/mcp";
    private static final String MESSAGE_ENDPOINT = "/message";
    public static final String MCP_SERVER_MESSAGE = "mcp-server/message";
    public static final String USER_ID = Endpoint.class.getName() + ".userId";
    public static final String HTTP_SERVLET_REQUEST = Endpoint.class.getName() + ".httpServletRequest";
    private static final String MCP_CONTEXT_KEY = Endpoint.class.getName() + ".mcpContext";
    private static int keepAliveInterval = SystemProperties.getInteger((String)(Endpoint.class.getName() + ".keepAliveInterval"), (Integer)0);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean REQUIRE_ORIGIN_HEADER = SystemProperties.getBoolean((String)(Endpoint.class.getName() + ".requireOriginHeader"), (boolean)false);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean REQUIRE_ORIGIN_MATCH = SystemProperties.getBoolean((String)(Endpoint.class.getName() + ".requireOriginMatch"), (boolean)true);
    private final ObjectMapper objectMapper = new ObjectMapper();
    HttpServletSseServerTransportProvider httpServletSseServerTransportProvider;
    HttpServletStreamableServerTransportProvider httpServletStreamableServerTransportProvider;

    public Endpoint() throws ServletException {
        this.init();
    }

    public static String getRequestedResourcePath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestedResource = Endpoint.getRequestedResourcePath(request);
        if (requestedResource.startsWith("/mcp-server/message") && request.getMethod().equalsIgnoreCase("POST")) {
            this.handleMessage(request, response, (HttpServlet)this.httpServletSseServerTransportProvider);
            return true;
        }
        if (requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("POST")) {
            response.sendError(405);
            return true;
        }
        if (this.isStreamableRequest(request)) {
            this.handleMessage(request, response, (HttpServlet)this.httpServletStreamableServerTransportProvider);
            return true;
        }
        if (this.isOAuthRegisterEndpoint(requestedResource)) {
            response.setStatus(404);
            response.setContentType("application/json");
            response.getWriter().write("{\"error\":\"not_found\",\"error_description\":\"OAuth /register not supported. Use Basic Auth with Jenkins API token.\"}");
            response.getWriter().flush();
            return true;
        }
        return false;
    }

    private boolean isOAuthRegisterEndpoint(String requestedResource) {
        return requestedResource.equals("/register");
    }

    protected void init() throws ServletException {
        McpSchema.ServerCapabilities serverCapabilities = McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).resources(Boolean.valueOf(true), Boolean.valueOf(true)).build();
        ExtensionList<McpServerExtension> extensions = McpServerExtension.all();
        List tools = extensions.stream().map(McpServerExtension::getSyncTools).flatMap(Collection::stream).toList();
        List prompts = extensions.stream().map(McpServerExtension::getSyncPrompts).flatMap(Collection::stream).toList();
        List resources = extensions.stream().map(McpServerExtension::getSyncResources).flatMap(Collection::stream).toList();
        List annotationTools = extensions.stream().flatMap(extension -> Arrays.stream(extension.getClass().getMethods()).filter(method -> method.isAnnotationPresent(Tool.class)).map(method -> new McpToolWrapper(this.objectMapper, extension, (Method)method).asSyncToolSpecification())).toList();
        ArrayList allTools = new ArrayList();
        allTools.addAll(tools);
        allTools.addAll(annotationTools);
        String rootUrl = JenkinsLocationConfiguration.get().getUrl();
        if (rootUrl == null) {
            rootUrl = "";
        }
        this.httpServletSseServerTransportProvider = HttpServletSseServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).baseUrl(rootUrl).sseEndpoint(SSE_ENDPOINT).messageEndpoint(MCP_SERVER_MESSAGE).contextExtractor(Endpoint.createExtractor()).keepAliveInterval(keepAliveInterval > 0 ? Duration.ofSeconds(keepAliveInterval) : null).build();
        McpServer.sync((McpServerTransportProvider)this.httpServletSseServerTransportProvider).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).jsonSchemaValidator((JsonSchemaValidator)new DefaultJsonSchemaValidator(this.objectMapper)).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
        this.httpServletStreamableServerTransportProvider = HttpServletStreamableServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).mcpEndpoint(STREAMABLE_ENDPOINT).contextExtractor(Endpoint.createExtractor()).keepAliveInterval(keepAliveInterval > 0 ? Duration.ofSeconds(keepAliveInterval) : null).build();
        McpServer.sync((McpStreamableServerTransportProvider)this.httpServletStreamableServerTransportProvider).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(this.objectMapper)).jsonSchemaValidator((JsonSchemaValidator)new DefaultJsonSchemaValidator(this.objectMapper)).capabilities(serverCapabilities).tools(allTools).prompts(prompts).resources(resources).build();
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (this.isSSERequest(req)) {
            this.handleSSE(req, resp);
            return true;
        }
        if (this.isStreamableRequest(req)) {
            if (this.isBrowserRequest(req)) {
                resp.setStatus(400);
                resp.setContentType("text/html;charset=UTF-8");
                resp.getWriter().write("<html><head><title>Model Context Protocol Endpoint</title></head><body><h2>This endpoint is designed for an AI agent using the Model Context Protocol.</h2></body></html>");
                resp.getWriter().flush();
            } else {
                this.handleMessage(req, resp, (HttpServlet)this.httpServletStreamableServerTransportProvider);
            }
            return true;
        }
        return false;
    }

    private boolean isBrowserRequest(HttpServletRequest req) {
        if (req.getMethod().equalsIgnoreCase("GET")) {
            String acceptHeader = req.getHeader("Accept");
            return acceptHeader != null && acceptHeader.contains("text/html");
        }
        return false;
    }

    private static McpTransportContextExtractor<HttpServletRequest> createExtractor() {
        return httpServletRequest -> (McpTransportContext)httpServletRequest.getAttribute(MCP_CONTEXT_KEY);
    }

    private boolean validOriginHeader(HttpServletRequest request, HttpServletResponse response) {
        String originHeaderValue = request.getHeader("Origin");
        if (REQUIRE_ORIGIN_HEADER && StringUtils.isEmpty((CharSequence)originHeaderValue)) {
            try {
                response.sendError(403, "Missing Origin header");
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (REQUIRE_ORIGIN_MATCH && !StringUtils.isEmpty((CharSequence)originHeaderValue)) {
            String expectedOrigin;
            String removeSuffix2;
            String removeSuffix1;
            String jenkinsRootUrl = JenkinsLocationConfiguration.get().getUrl();
            if (StringUtils.isEmpty((CharSequence)jenkinsRootUrl)) {
                return true;
            }
            String o = this.getRootUrlFromRequest(request);
            if (o.endsWith(removeSuffix1 = "/")) {
                o = o.substring(0, o.length() - removeSuffix1.length());
            }
            if (o.endsWith(removeSuffix2 = request.getContextPath())) {
                o = o.substring(0, o.length() - removeSuffix2.length());
            }
            if (!originHeaderValue.equals(expectedOrigin = o)) {
                log.debug("Rejecting origin: {}; expected was from request: {}", (Object)originHeaderValue, (Object)expectedOrigin);
                try {
                    response.sendError(403, "Unexpected request origin (check your reverse proxy settings)");
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    @NonNull
    private String getRootUrlFromRequest(HttpServletRequest req) {
        StringBuilder buf = new StringBuilder();
        String scheme = Endpoint.getXForwardedHeader(req, "X-Forwarded-Proto", req.getScheme());
        buf.append(scheme).append("://");
        String host = Endpoint.getXForwardedHeader(req, "X-Forwarded-Host", req.getServerName());
        int index = host.lastIndexOf(58);
        int port = req.getServerPort();
        if (index == -1) {
            buf.append(host);
        } else if (host.startsWith("[") && host.endsWith("]")) {
            buf.append(host);
        } else {
            buf.append(host, 0, index);
            if (index + 1 < host.length()) {
                try {
                    port = Integer.parseInt(host.substring(index + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String forwardedPort = Endpoint.getXForwardedHeader(req, "X-Forwarded-Port", null);
        if (forwardedPort != null) {
            try {
                port = Integer.parseInt(forwardedPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port != ("https".equals(scheme) ? 443 : 80)) {
            buf.append(':').append(port);
        }
        buf.append(req.getContextPath()).append('/');
        return buf.toString();
    }

    private static String getXForwardedHeader(HttpServletRequest req, String header, String defaultValue) {
        String value = req.getHeader(header);
        if (value != null) {
            int index = value.indexOf(44);
            return index == -1 ? value.trim() : value.substring(0, index).trim();
        }
        return defaultValue;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return MCP_SERVER;
    }

    private boolean isSSERequest(HttpServletRequest request) {
        String requestedResource = Endpoint.getRequestedResourcePath(request);
        return requestedResource.startsWith("/mcp-server/sse") && request.getMethod().equalsIgnoreCase("GET");
    }

    private boolean isStreamableRequest(HttpServletRequest request) {
        String requestedResource = Endpoint.getRequestedResourcePath(request);
        return requestedResource.startsWith("/mcp-server/mcp") && (request.getMethod().equalsIgnoreCase("GET") || request.getMethod().equalsIgnoreCase("POST"));
    }

    private void handleSSE(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.httpServletSseServerTransportProvider.service((ServletRequest)request, (ServletResponse)response);
    }

    private void handleMessage(HttpServletRequest request, HttpServletResponse response, HttpServlet httpServlet) throws IOException, ServletException {
        if (!this.validOriginHeader(request, response)) {
            return;
        }
        Endpoint.prepareMcpContext(request);
        httpServlet.service((ServletRequest)request, (ServletResponse)response);
    }

    private static void prepareMcpContext(HttpServletRequest request) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        User currentUser = User.current();
        String userId = null;
        if (currentUser != null) {
            userId = currentUser.getId();
        }
        if (userId != null) {
            contextMap.put(USER_ID, userId);
        }
        contextMap.put(HTTP_SERVLET_REQUEST, (String)request);
        request.setAttribute(MCP_CONTEXT_KEY, (Object)McpTransportContext.create(contextMap));
    }
}

