/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jenkins.util.VirtualFile;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class BuildArtifactsExtension
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildArtifactsExtension.class);

    @Tool(description="Get the artifacts for a specific build or the last build of a Jenkins job")
    public List<Run.Artifact> getBuildArtifacts(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber) {
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(Run::getArtifacts).orElse(List.of());
    }

    @Tool(description="Get the content of a specific build artifact with pagination support. Returns the artifact content as text with information about whether there is more content to retrieve.")
    public BuildArtifactResponse getBuildArtifact(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber, @ToolParam(description="Relative path of the artifact from the artifacts root") String artifactPath, @Nullable @ToolParam(description="The byte offset to start reading from (optional, if not provided, starts from the beginning)", required=false) Long offset, @Nullable @ToolParam(description="The maximum number of bytes to read (optional, if not provided, reads up to 64KB)", required=false) Integer limit) {
        if (offset == null || offset < 0L) {
            offset = 0L;
        }
        if (limit == null || limit <= 0) {
            limit = 65536;
        }
        int maxLimit = 0x100000;
        if (limit > 0x100000) {
            log.warn("Limit {} is too large, using the default max limit {}", (Object)limit, (Object)0x100000);
            limit = 0x100000;
        }
        long offsetF = offset;
        int limitF = limit;
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            try {
                return this.getArtifactContent((Run)build, artifactPath, offsetF, limitF);
            }
            catch (Exception e) {
                log.error("Error reading artifact {} for job {} build {}", new Object[]{artifactPath, jobFullName, buildNumber, e});
                return new BuildArtifactResponse(false, 0L, "Error reading artifact: " + e.getMessage());
            }
        }).orElse(new BuildArtifactResponse(false, 0L, "Build not found"));
    }

    private BuildArtifactResponse getArtifactContent(Run run, String artifactPath, long offset, int limit) throws IOException {
        log.trace("getArtifactContent for run {}/{} called with artifact {}, offset {}, limit {}", new Object[]{run.getParent().getName(), run.getDisplayName(), artifactPath, offset, limit});
        Run.Artifact artifact = null;
        for (Object a : run.getArtifacts()) {
            Run.Artifact runArtifact = (Run.Artifact)a;
            if (!runArtifact.relativePath.equals(artifactPath)) continue;
            artifact = runArtifact;
            break;
        }
        if (artifact == null) {
            return new BuildArtifactResponse(false, 0L, "Artifact not found: " + artifactPath);
        }
        VirtualFile artifactFile = run.getArtifactManager().root().child(artifactPath);
        if (!artifactFile.exists()) {
            return new BuildArtifactResponse(false, 0L, "Artifact file does not exist: " + artifactPath);
        }
        long fileSize = artifactFile.length();
        if (offset >= fileSize) {
            return new BuildArtifactResponse(false, fileSize, "");
        }
        try (InputStream is = artifactFile.open();){
            byte[] buffer;
            int bytesRead;
            long skipped = is.skip(offset);
            if (skipped != offset) {
                log.warn("Could not skip to offset {}, only skipped {}", (Object)offset, (Object)skipped);
            }
            if ((bytesRead = is.read(buffer = new byte[limit])) <= 0) {
                BuildArtifactResponse buildArtifactResponse = new BuildArtifactResponse(false, fileSize, "");
                return buildArtifactResponse;
            }
            String content = new String(buffer, 0, bytesRead, StandardCharsets.UTF_8);
            boolean hasMoreContent = offset + (long)bytesRead < fileSize;
            BuildArtifactResponse buildArtifactResponse = new BuildArtifactResponse(hasMoreContent, fileSize, content);
            return buildArtifactResponse;
        }
    }

    public record BuildArtifactResponse(boolean hasMoreContent, long totalSize, String content) {
    }
}

