/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import hudson.model.Run;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.Property;
import org.kohsuke.stapler.export.TreePruner;

public class RunWithoutArtifactsSerializer
extends JsonSerializer<Run> {
    private static final ModelBuilder MODEL_BUILDER = new ModelBuilder();
    private static final TreePruner ARTIFACTS_PRUNER = new TreePruner(){

        public TreePruner accept(Object node, Property prop) {
            return "artifacts".equals(prop.name) ? null : TreePruner.DEFAULT;
        }
    };

    public void serialize(Run value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        StringWriter sw = new StringWriter();
        ExportConfig config = new ExportConfig().withFlavor(Flavor.JSON);
        DataWriter dw = Flavor.JSON.createDataWriter((Object)value, (Writer)sw, config);
        Model model = MODEL_BUILDER.get(value.getClass());
        model.writeTo((Object)value, ARTIFACTS_PRUNER, dw);
        gen.writeRawValue(sw.toString());
    }
}

