/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.matrix_communication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cosium.matrix_communication_client.MatrixResources;
import com.cosium.matrix_communication_client.Message;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.security.auth.login.CredentialNotFoundException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SendMessageStep
extends Step {
    private boolean https = true;
    private String hostname;
    private Integer port;
    private String accessTokenCredentialsId;
    private String roomId;
    private String body;
    private String format = "org.matrix.custom.html";
    private String formattedBody;
    private String type = "m.text";

    @DataBoundConstructor
    public SendMessageStep() {
    }

    public boolean isHttps() {
        return this.https;
    }

    @DataBoundSetter
    public void setHttps(boolean https) {
        this.https = https;
    }

    public String getHostname() {
        return this.hostname;
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    @DataBoundSetter
    public void setPort(Integer port) {
        this.port = port;
    }

    public String getAccessTokenCredentialsId() {
        return this.accessTokenCredentialsId;
    }

    @DataBoundSetter
    public void setAccessTokenCredentialsId(String accessTokenCredentialsId) {
        this.accessTokenCredentialsId = accessTokenCredentialsId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    @DataBoundSetter
    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getBody() {
        return this.body;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    public String getFormat() {
        return this.format;
    }

    @DataBoundSetter
    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormattedBody() {
        return this.formattedBody;
    }

    @DataBoundSetter
    public void setFormattedBody(String formattedBody) {
        this.formattedBody = formattedBody;
    }

    public String getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(String type) {
        this.type = type;
    }

    public StepExecution start(StepContext context) {
        Execution execution = new Execution(context);
        execution.https = this.https;
        execution.hostname = this.hostname;
        execution.port = this.port;
        execution.accessTokenCredentialsId = this.accessTokenCredentialsId;
        execution.roomId = this.roomId;
        execution.body = this.body;
        execution.format = this.format;
        execution.formattedBody = this.formattedBody;
        execution.type = this.type;
        return execution;
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final Logger LOGGER = Logger.getLogger(Execution.class.getName());
        private boolean https;
        private String hostname;
        private Integer port;
        private String accessTokenCredentialsId;
        private String roomId;
        private String body;
        private String format;
        private String formattedBody;
        private String type;

        protected Execution(@Nonnull StepContext context) {
            super(context);
        }

        protected Void run() throws CredentialNotFoundException, IOException, InterruptedException {
            String accessToken = this.findAccessTokenSecret().map(Secret::getPlainText).orElse(null);
            MatrixResources matrixResources = MatrixResources.factory().builder().https(this.https).hostname(this.hostname).port(this.port).accessToken(accessToken).build();
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            Objects.requireNonNull(taskListener, String.format("Could not retrieve %s", TaskListener.class));
            String withAccessToken = accessToken != null ? "with access token" : "without access token";
            taskListener.getLogger().printf("Sending Matrix message {type: '%s', format: '%s', body: '%s', formattedBody: '%s'} to {https: %s, hostname: '%s', port: %s} %s%n", this.type, this.format, this.body, this.formattedBody, this.https, this.hostname, this.port, withAccessToken);
            matrixResources.rooms().byId(this.roomId).sendMessage(Message.builder().type(this.type).format(this.format).body(this.body).formattedBody(this.formattedBody).build());
            taskListener.getLogger().println("Matrix message sent");
            return null;
        }

        private Optional<Secret> findAccessTokenSecret() throws CredentialNotFoundException {
            if (this.accessTokenCredentialsId == null) {
                LOGGER.log(Level.FINE, "accessTokenCredentialsId is null");
                return Optional.empty();
            }
            LOGGER.log(Level.FINE, () -> String.format("Looking for credentials with id '%s'", this.accessTokenCredentialsId));
            StandardCredentials accessTokenCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.get(), null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.accessTokenCredentialsId));
            if (accessTokenCredentials == null) {
                throw new CredentialNotFoundException(String.format("No credentials found for id '%s'", this.accessTokenCredentialsId));
            }
            if (accessTokenCredentials instanceof StringCredentials) {
                LOGGER.log(Level.FINE, () -> String.format("Found '%s'", accessTokenCredentials));
                return Optional.of(accessTokenCredentials).map(StringCredentials.class::cast).map(StringCredentials::getSecret);
            }
            if (accessTokenCredentials instanceof PasswordCredentials) {
                LOGGER.log(Level.FINE, () -> String.format("Found '%s'", accessTokenCredentials));
                return Optional.of(accessTokenCredentials).map(PasswordCredentials.class::cast).map(PasswordCredentials::getPassword);
            }
            throw new CredentialNotFoundException(String.format("Cannot handle %s", accessTokenCredentials));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Send message to a Matrix room";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class);
        }

        public String getFunctionName() {
            return "matrixSendMessage";
        }
    }
}

