/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.matomoanalytics;

import hudson.Extension;
import hudson.ExtensionList;
import io.jenkins.plugins.matomoanalytics.MatomoPageDecorator;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

@Extension
@SuppressRestrictedWarnings(value={Contributor.class, CspBuilder.class})
public class MatomoContributor
implements Contributor {
    public void apply(CspBuilder cspBuilder) {
        MatomoPageDecorator decorator = (MatomoPageDecorator)((Object)ExtensionList.lookupSingleton(MatomoPageDecorator.class));
        String server = decorator.getMatomoServer();
        String siteId = decorator.getMatomoSiteID();
        if (server != null && siteId != null) {
            String path;
            String matomoJs = decorator.getMatomoJs();
            if (matomoJs == null) {
                matomoJs = "matomo.js";
            }
            if ((path = decorator.getMatomoPath()) == null) {
                path = "";
            }
            String scriptUrl = decorator.getProtocolString() + server + path + matomoJs;
            cspBuilder.add("script-src", new String[]{scriptUrl});
        }
    }
}

