/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locale;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.plugins.locale.LocaleFilter;
import hudson.util.ListBoxModel;
import hudson.util.PluginServletFilter;
import hudson.util.XStream2;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"locale"})
public class PluginImpl
extends GlobalConfiguration {
    private static final XStream XSTREAM = new XStream2();
    private String systemLocale;
    private boolean ignoreAcceptLanguage;
    private boolean allowUserPreferences;
    public static final String USE_BROWSER_LOCALE = "USE_BROWSER_LOCALE";
    public static final Set<String> ALLOWED_LOCALES;
    private final transient Locale originalLocale = Locale.getDefault();

    public static PluginImpl get() {
        return (PluginImpl)((Object)Jenkins.get().getExtensionList(PluginImpl.class).get(0));
    }

    public PluginImpl() {
        this.load();
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.get().getRootDir(), "locale.xml"));
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws Exception {
        PluginImpl.get().start();
    }

    private void start() throws ServletException {
        this.load();
        LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){
            final LocaleProvider original = LocaleProvider.getProvider();

            public Locale get() {
                if (PluginImpl.this.ignoreAcceptLanguage) {
                    return Locale.getDefault();
                }
                return this.original.get();
            }
        });
        PluginServletFilter.addFilter((Filter)new LocaleFilter());
    }

    public void load() {
        super.load();
        if (this.systemLocale == null || this.systemLocale.isEmpty()) {
            this.setSystemLocale(USE_BROWSER_LOCALE);
        } else {
            this.setSystemLocale(this.systemLocale);
        }
    }

    public boolean configure(StaplerRequest2 req, JSONObject jsonObject) {
        req.bindJSON((Object)this, jsonObject);
        this.save();
        return false;
    }

    public boolean isIgnoreAcceptLanguage() {
        return this.ignoreAcceptLanguage;
    }

    public boolean isAllowUserPreferences() {
        return this.allowUserPreferences;
    }

    public String getSystemLocale() {
        return this.systemLocale;
    }

    public void setSystemLocale(String systemLocale) {
        if (USE_BROWSER_LOCALE.equals(systemLocale = Util.fixEmptyAndTrim((String)systemLocale))) {
            Locale.setDefault(this.originalLocale);
            this.systemLocale = USE_BROWSER_LOCALE;
        } else {
            Locale.setDefault(systemLocale == null || systemLocale.isEmpty() ? this.originalLocale : PluginImpl.parse(systemLocale));
            this.systemLocale = systemLocale;
        }
    }

    public void setIgnoreAcceptLanguage(boolean ignoreAcceptLanguage) {
        this.ignoreAcceptLanguage = ignoreAcceptLanguage;
    }

    public void setAllowUserPreferences(boolean allowUserPreferences) {
        this.allowUserPreferences = allowUserPreferences;
    }

    public static Locale parse(String s) {
        String[] tokens = s.trim().split("_");
        return switch (tokens.length) {
            case 1 -> new Locale(tokens[0]);
            case 2 -> new Locale(tokens[0], tokens[1]);
            case 3 -> new Locale(tokens[0], tokens[1], tokens[2]);
            default -> throw new IllegalArgumentException(s + " is not a valid locale");
        };
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    @RequirePOST
    public ListBoxModel doFillSystemLocaleItems() {
        ListBoxModel items = new ListBoxModel();
        String originalLocaleDisplay = String.format("Use Default Locale - %s (%s)", this.originalLocale.getDisplayName(), this.originalLocale);
        items.add((Object)new ListBoxModel.Option(originalLocaleDisplay, USE_BROWSER_LOCALE));
        Locale[] availableLocales = Locale.getAvailableLocales();
        List<Locale> sortedLocales = Arrays.stream(availableLocales).filter(locale -> ALLOWED_LOCALES.contains(locale.toString())).sorted(Comparator.comparing(Locale::getDisplayName)).toList();
        for (Locale locale2 : sortedLocales) {
            String displayText = String.format("%s - %s", locale2.getDisplayName(), locale2);
            items.add((Object)new ListBoxModel.Option(displayText, locale2.toString()));
        }
        return items;
    }

    static {
        XSTREAM.alias("locale", PluginImpl.class);
        ALLOWED_LOCALES = Set.of("bg", "ca", "cs", "da", "de", "el", "en", "es", "es_AR", "et", "fi", "fr", "he", "hu", "it", "ja", "ko", "lt", "lv", "nb_NO", "nl", "pl", "pt_BR", "pt_PT", "ro", "ru", "sk", "sl", "sr", "sv", "tr", "uk", "zh_CN", "zh_TW");
    }
}

