/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locale.user;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.userproperty.UserPropertyCategory;
import hudson.plugins.locale.Messages;
import hudson.plugins.locale.PluginImpl;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UserLocaleProperty
extends UserProperty {
    private static final Logger LOGGER = Logger.getLogger(UserLocaleProperty.class.getName());
    private String localeCode;
    private Locale locale;

    @DataBoundConstructor
    public UserLocaleProperty(String localeCode) {
        this.localeCode = localeCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    @DataBoundSetter
    public void setLocaleCode(String localeCode) {
        try {
            this.locale = PluginImpl.parse(localeCode);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, ex, () -> "Unable to determine locale for locale code " + localeCode);
        }
        this.localeCode = localeCode;
    }

    @Extension
    @Symbol(value={"userLocale"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.locale();
        }

        public UserProperty newInstance(User user) {
            return new UserLocaleProperty(LocaleProvider.getLocale().toString());
        }

        public UserProperty newInstance(StaplerRequest2 req, @NonNull JSONObject formData) {
            return new UserLocaleProperty(formData.optString("localeCode"));
        }

        public boolean isEnabled() {
            PluginImpl plugin = PluginImpl.get();
            return plugin.isAllowUserPreferences();
        }

        @NonNull
        public UserPropertyCategory getUserPropertyCategory() {
            return UserPropertyCategory.get(UserPropertyCategory.Appearance.class);
        }

        @RequirePOST
        public ListBoxModel doFillLocaleCodeItems() {
            ListBoxModel items = new ListBoxModel();
            Locale originalLocale = LocaleProvider.getLocale();
            String originalLocaleDisplay = String.format("Use Default Locale - %s (%s)", originalLocale.getDisplayName(), originalLocale);
            items.add((Object)new ListBoxModel.Option(originalLocaleDisplay, "USE_BROWSER_LOCALE"));
            Locale[] availableLocales = Locale.getAvailableLocales();
            List<Locale> sortedLocales = Arrays.stream(availableLocales).filter(locale -> PluginImpl.ALLOWED_LOCALES.contains(locale.toString())).sorted(Comparator.comparing(Locale::getDisplayName)).toList();
            for (Locale locale2 : sortedLocales) {
                String displayText = String.format("%s - %s", locale2.getDisplayName(), locale2);
                items.add((Object)new ListBoxModel.Option(displayText, locale2.toString()));
            }
            return items;
        }
    }
}

