/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locale;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.User;
import hudson.plugins.locale.PluginImpl;
import hudson.plugins.locale.user.UserLocaleProperty;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;

public class LocaleFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            PluginImpl plugin = PluginImpl.get();
            if (plugin == null) {
                chain.doFilter(request, response);
                return;
            }
            final Locale locale = plugin.isAllowUserPreferences() ? this.getCurrentUserLocale() : (plugin.isIgnoreAcceptLanguage() ? Locale.getDefault() : null);
            if (locale != null) {
                request = new HttpServletRequestWrapper(req){

                    public Locale getLocale() {
                        return locale;
                    }

                    public Enumeration<Locale> getLocales() {
                        return new Enumeration<Locale>(){
                            private boolean hasMoreElements = true;

                            @Override
                            public boolean hasMoreElements() {
                                return this.hasMoreElements;
                            }

                            @Override
                            public Locale nextElement() {
                                if (this.hasMoreElements) {
                                    this.hasMoreElements = false;
                                    return this.getLocale();
                                }
                                throw new NoSuchElementException();
                            }
                        };
                    }
                };
                ((HttpServletResponse)response).addHeader("X-Jenkins-Language", locale.toString());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    @CheckForNull
    private Locale getCurrentUserLocale() {
        User user = User.current();
        if (user != null) {
            UserLocaleProperty userLocaleProperty = (UserLocaleProperty)user.getProperty(UserLocaleProperty.class);
            if (userLocaleProperty == null) {
                return null;
            }
            return userLocaleProperty.getLocale();
        }
        return null;
    }
}

