// CHECKSTYLE:OFF

package hudson.plugins.locale;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code locale}: {@code Locale}.
     * 
     * @return
     *     {@code Locale}
     */
    public static String locale() {
        return holder.format("locale");
    }

    /**
     * Key {@code locale}: {@code Locale}.
     * 
     * @return
     *     {@code Locale}
     */
    public static Localizable _locale() {
        return new Localizable(holder, "locale");
    }

}
