/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.levo;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.levo.credentials.LevoCLICredentials;
import io.jenkins.plugins.levo.helpers.LevoDockerTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TestPlanBuilder
extends Builder
implements SimpleBuildStep {
    private List<String> target;
    private String testPlan;
    private String levoCredentialsId;
    private List<String> secretEnvironmentId;
    private List<Boolean> generateJunitReport;
    private List<String> extraCLIArgs;
    private String executionMode;
    private List<String> appName;
    private List<String> environment;
    private List<String> categories;
    private String httpMethods;
    private String excludeMethods;
    private String endpointPattern;
    private String excludeEndpointPattern;
    private String testUsers;
    private String targetUrl;
    private String dataSource;
    private String runOn;
    private String appNameDataSource;
    private String failSeverity;
    private String failScope;
    private String failThreshold;

    @DataBoundConstructor
    public TestPlanBuilder() {
    }

    @DataBoundSetter
    public void setCategoryCheckbox(List<Object> value) {
    }

    @DataBoundSetter
    public void setIncludeUser(List<Object> value) {
    }

    @DataBoundSetter
    public void setTarget(List<Object> target) {
        if (target != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : target) {
                if (item == null) continue;
                String s = item.toString();
                values.add(s);
            }
            this.target = values;
        } else {
            this.target = null;
        }
    }

    @DataBoundSetter
    public void setTarget(String target) {
        if (target != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(target);
            this.target = values;
        } else {
            this.target = null;
        }
    }

    @DataBoundSetter
    public void setTestPlan(String testPlan) {
        this.testPlan = testPlan;
    }

    @DataBoundSetter
    public void setLevoCredentialsId(String levoCredentialsId) {
        this.levoCredentialsId = levoCredentialsId;
    }

    @DataBoundSetter
    public void setGenerateJunitReport(List<Object> generateJunitReport) {
        if (generateJunitReport != null) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            for (Object item : generateJunitReport) {
                if (item == null) {
                    values.add(null);
                    continue;
                }
                if (item instanceof Boolean) {
                    values.add((Boolean)item);
                    continue;
                }
                String str = item.toString().toLowerCase();
                if ("true".equals(str) || "1".equals(str)) {
                    values.add(Boolean.TRUE);
                    continue;
                }
                if ("false".equals(str) || "0".equals(str) || str.isEmpty()) {
                    values.add(Boolean.FALSE);
                    continue;
                }
                values.add(null);
            }
            this.generateJunitReport = values;
        } else {
            this.generateJunitReport = null;
        }
    }

    @DataBoundSetter
    public void setGenerateJunitReport(Boolean generateJunitReport) {
        if (generateJunitReport != null) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            values.add(generateJunitReport);
            this.generateJunitReport = values;
        } else {
            this.generateJunitReport = null;
        }
    }

    @DataBoundSetter
    public void setExtraCLIArgs(List<Object> extraCLIArgs) {
        if (extraCLIArgs != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : extraCLIArgs) {
                if (item == null) continue;
                values.add(item.toString());
            }
            this.extraCLIArgs = values;
        } else {
            this.extraCLIArgs = null;
        }
    }

    @DataBoundSetter
    public void setExtraCLIArgs(String extraCLIArgs) {
        if (extraCLIArgs != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(extraCLIArgs);
            this.extraCLIArgs = values;
        } else {
            this.extraCLIArgs = null;
        }
    }

    @DataBoundSetter
    public void setSecretEnvironmentId(List<Object> secretEnvironmentId) {
        if (secretEnvironmentId != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : secretEnvironmentId) {
                if (item == null) continue;
                values.add(item.toString());
            }
            this.secretEnvironmentId = values;
        } else {
            this.secretEnvironmentId = null;
        }
    }

    @DataBoundSetter
    public void setSecretEnvironmentId(String secretEnvironmentId) {
        if (secretEnvironmentId != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(secretEnvironmentId);
            this.secretEnvironmentId = values;
        } else {
            this.secretEnvironmentId = null;
        }
    }

    @DataBoundSetter
    public void setExecutionMode(String executionMode) {
        this.executionMode = executionMode;
    }

    @DataBoundSetter
    public void setAppName(List<Object> appName) {
        if (appName != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : appName) {
                if (item == null) continue;
                values.add(item.toString());
            }
            this.appName = values;
        } else {
            this.appName = null;
        }
    }

    @DataBoundSetter
    public void setAppName(String appName) {
        if (appName != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(appName);
            this.appName = values;
        } else {
            this.appName = null;
        }
    }

    @DataBoundSetter
    public void setEnvironment(List<Object> environment) {
        if (environment != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : environment) {
                if (item == null) continue;
                values.add(item.toString());
            }
            this.environment = values;
        } else {
            this.environment = null;
        }
    }

    @DataBoundSetter
    public void setEnvironment(String environment) {
        if (environment != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(environment);
            this.environment = values;
        } else {
            this.environment = null;
        }
    }

    @DataBoundSetter
    public void setCategories(List<Object> categories) {
        if (categories != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : categories) {
                if (item == null) continue;
                values.add(item.toString());
            }
            this.categories = values;
        } else {
            this.categories = null;
        }
    }

    @DataBoundSetter
    public void setCategories(String categories) {
        if (categories != null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(categories);
            this.categories = values;
        } else {
            this.categories = null;
        }
    }

    @DataBoundSetter
    public void setHttpMethods(List<Object> httpMethods) {
        if (httpMethods != null) {
            for (Object item : httpMethods) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.httpMethods = item.toString().trim();
                return;
            }
        }
        this.httpMethods = null;
    }

    @DataBoundSetter
    public void setHttpMethods(String httpMethods) {
        this.httpMethods = httpMethods;
    }

    @DataBoundSetter
    public void setExcludeMethods(List<Object> excludeMethods) {
        if (excludeMethods != null) {
            for (Object item : excludeMethods) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.excludeMethods = item.toString().trim();
                return;
            }
        }
        this.excludeMethods = null;
    }

    @DataBoundSetter
    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    @DataBoundSetter
    public void setEndpointPattern(List<Object> endpointPattern) {
        if (endpointPattern != null) {
            for (Object item : endpointPattern) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.endpointPattern = item.toString().trim();
                return;
            }
        }
        this.endpointPattern = null;
    }

    @DataBoundSetter
    public void setEndpointPattern(String endpointPattern) {
        this.endpointPattern = endpointPattern;
    }

    @DataBoundSetter
    public void setExcludeEndpointPattern(List<Object> excludeEndpointPattern) {
        if (excludeEndpointPattern != null) {
            for (Object item : excludeEndpointPattern) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.excludeEndpointPattern = item.toString().trim();
                return;
            }
        }
        this.excludeEndpointPattern = null;
    }

    @DataBoundSetter
    public void setExcludeEndpointPattern(String excludeEndpointPattern) {
        this.excludeEndpointPattern = excludeEndpointPattern;
    }

    @DataBoundSetter
    public void setTestUsers(List<Object> testUsers) {
        if (testUsers != null) {
            for (Object item : testUsers) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.testUsers = item.toString().trim();
                return;
            }
        }
        this.testUsers = null;
    }

    @DataBoundSetter
    public void setTestUsers(String testUsers) {
        this.testUsers = testUsers;
    }

    @DataBoundSetter
    public void setTargetUrl(List<Object> targetUrl) {
        if (targetUrl != null) {
            for (Object item : targetUrl) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.targetUrl = item.toString().trim();
                return;
            }
        }
        this.targetUrl = null;
    }

    @DataBoundSetter
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @DataBoundSetter
    public void setFailSeverity(List<Object> failSeverity) {
        if (failSeverity != null) {
            for (Object item : failSeverity) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.failSeverity = item.toString().trim();
                return;
            }
        }
        this.failSeverity = null;
    }

    @DataBoundSetter
    public void setFailSeverity(String failSeverity) {
        this.failSeverity = failSeverity;
    }

    @DataBoundSetter
    public void setFailScope(List<Object> failScope) {
        if (failScope != null) {
            for (Object item : failScope) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.failScope = item.toString().trim();
                return;
            }
        }
        this.failScope = null;
    }

    @DataBoundSetter
    public void setFailScope(String failScope) {
        this.failScope = failScope;
    }

    @DataBoundSetter
    public void setFailThreshold(List<Object> failThreshold) {
        if (failThreshold != null) {
            for (Object item : failThreshold) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.failThreshold = item.toString().trim();
                return;
            }
        }
        this.failThreshold = null;
    }

    @DataBoundSetter
    public void setFailThreshold(String failThreshold) {
        this.failThreshold = failThreshold;
    }

    public String getTarget() {
        if (this.target != null) {
            for (String s : this.target) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getTestPlan() {
        return this.testPlan;
    }

    public String getExtraCLIArgs() {
        if (this.extraCLIArgs != null) {
            for (String s : this.extraCLIArgs) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getSecretEnvironmentId() {
        if (this.secretEnvironmentId != null) {
            for (String s : this.secretEnvironmentId) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getLevoCredentialsId() {
        return this.levoCredentialsId;
    }

    public Boolean getGenerateJunitReport() {
        if (this.generateJunitReport != null) {
            for (Boolean b : this.generateJunitReport) {
                if (b == null) continue;
                return b;
            }
        }
        return Boolean.FALSE;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public String getAppName() {
        if (this.appName != null) {
            for (String s : this.appName) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getEnvironment() {
        if (this.environment != null) {
            for (String s : this.environment) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getCategories() {
        if (this.categories != null) {
            for (String s : this.categories) {
                if (s == null || s.trim().isEmpty()) continue;
                return s;
            }
        }
        return null;
    }

    public String getHttpMethods() {
        return this.httpMethods;
    }

    public String getExcludeMethods() {
        return this.excludeMethods;
    }

    public String getEndpointPattern() {
        return this.endpointPattern;
    }

    public String getExcludeEndpointPattern() {
        return this.excludeEndpointPattern;
    }

    public String getTestUsers() {
        return this.testUsers;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    @DataBoundSetter
    public void setDataSource(List<Object> dataSource) {
        if (dataSource != null) {
            for (Object item : dataSource) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.dataSource = item.toString().trim();
                return;
            }
        }
        this.dataSource = null;
    }

    @DataBoundSetter
    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getAppNameDataSource() {
        return this.appNameDataSource;
    }

    @DataBoundSetter
    public void setAppNameDataSource(List<Object> appNameDataSource) {
        if (appNameDataSource != null) {
            for (Object item : appNameDataSource) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.appNameDataSource = item.toString().trim();
                return;
            }
        }
        this.appNameDataSource = null;
    }

    @DataBoundSetter
    public void setAppNameDataSource(String appNameDataSource) {
        this.appNameDataSource = appNameDataSource;
    }

    public String getRunOn() {
        return this.runOn;
    }

    @DataBoundSetter
    public void setRunOn(List<Object> runOn) {
        if (runOn != null) {
            for (Object item : runOn) {
                if (item == null || item.toString().trim().isEmpty()) continue;
                this.runOn = item.toString().trim();
                return;
            }
        }
        this.runOn = null;
    }

    @DataBoundSetter
    public void setRunOn(String runOn) {
        this.runOn = runOn;
    }

    public String getFailSeverity() {
        return this.failSeverity;
    }

    public String getFailScope() {
        return this.failScope;
    }

    public String getFailThreshold() {
        return this.failThreshold;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        String mode;
        LevoCLICredentials credentials = (LevoCLICredentials)CredentialsProvider.findCredentialById((String)this.levoCredentialsId, LevoCLICredentials.class, run, (List)Lists.newArrayList());
        if (credentials == null) {
            listener.error("Levo Credentials not found");
            return;
        }
        String environmentFileContent = null;
        String resolvedSecretEnvironmentId = this.getSecretEnvironmentId();
        if (resolvedSecretEnvironmentId != null && !resolvedSecretEnvironmentId.trim().isEmpty()) {
            StringCredentials secretCredentials = (StringCredentials)CredentialsProvider.findCredentialById((String)resolvedSecretEnvironmentId, StringCredentials.class, run, (List)Lists.newArrayList());
            if (secretCredentials == null) {
                FileCredentials secretFileCredentials = (FileCredentials)CredentialsProvider.findCredentialById((String)resolvedSecretEnvironmentId, FileCredentials.class, run, (List)Lists.newArrayList());
                if (secretFileCredentials == null) {
                    listener.error("Defined Secret Environment not found: " + resolvedSecretEnvironmentId);
                    run.setResult(Result.FAILURE);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(secretFileCredentials.getContent(), StandardCharsets.UTF_8));){
                    environmentFileContent = reader.lines().collect(Collectors.joining("\n"));
                }
            } else {
                environmentFileContent = secretCredentials.getSecret().getPlainText();
            }
        }
        LevoDockerTool.runLevoLogin(run, launcher, env, this.getPath(launcher, workspace), credentials.getAuthorizationKey(), credentials.getOrganizationId(), credentials.getBaseUrl());
        String string = mode = this.executionMode != null && !this.executionMode.isEmpty() ? this.executionMode : "appName";
        if ("remoteTestRun".equals(mode)) {
            LevoDockerTool.runLevoRemoteTestRun(run, launcher, env, run.getEnvironment(listener), this.getPath(launcher, workspace), this.getAppName(), this.getEnvironment(), this.getCategories(), this.httpMethods, this.excludeMethods, this.endpointPattern, this.excludeEndpointPattern, this.testUsers, this.targetUrl, this.dataSource, this.runOn, this.failSeverity, this.failScope, this.failThreshold, credentials.getAuthorizationKey(), credentials.getOrganizationId(), credentials.getBaseUrl());
        } else if ("appName".equals(mode)) {
            String target = this.getTarget();
            if (target == null || target.trim().isEmpty()) {
                throw new IllegalArgumentException("Target URL is required when using Application Name mode");
            }
            LevoDockerTool.runLevoTestPlan(run, launcher, env, run.getEnvironment(listener), this.getPath(launcher, workspace), target, null, this.getAppName(), this.getEnvironment(), this.getCategories(), this.appNameDataSource, null, environmentFileContent, this.getGenerateJunitReport(), this.getExtraCLIArgs(), credentials.getOrganizationId(), credentials.getBaseUrl());
        } else {
            LevoDockerTool.runLevoTestPlan(run, launcher, env, run.getEnvironment(listener), this.getPath(launcher, workspace), this.getTarget(), this.testPlan, null, null, null, null, null, environmentFileContent, this.getGenerateJunitReport(), this.getExtraCLIArgs(), credentials.getOrganizationId(), credentials.getBaseUrl());
        }
    }

    private String getPath(Launcher launcher, FilePath filePath) throws IOException, InterruptedException {
        return launcher.isUnix() ? filePath.getRemote() : filePath.toURI().getPath().substring(1).replace("\\", "/");
    }

    @Symbol(value={"levo-test-plan"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(TestPlanBuilder.class);
        }

        public String getDisplayName() {
            return "Levo Test Plan";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillLevoCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String levoCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(levoCredentialsId);
            }
            return CredentialsProvider.listCredentials(LevoCLICredentials.class, (Item)null, null, (List)Lists.newArrayList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(LevoCLICredentials.class));
        }

        public ListBoxModel doFillSecretEnvironmentIdItems(@AncestorInPath Item item, @QueryParameter String secretEnvironmentId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(secretEnvironmentId);
            }
            return CredentialsProvider.listCredentials(StandardCredentials.class, (Item)null, null, (List)Lists.newArrayList(), (CredentialsMatcher)CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}));
        }

        @RequirePOST
        public FormValidation doCheckAppName(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (("appName".equals(executionMode) || "remoteTestRun".equals(executionMode)) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Application name is required when using app-based testing");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckEnvironment(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (("appName".equals(executionMode) || "remoteTestRun".equals(executionMode)) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Environment is required when using app-based testing");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckTarget(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (("testPlan".equals(executionMode) || executionMode == null || executionMode.isEmpty()) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Target URL is required when using Test Plan LRN");
            }
            if ("appName".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Target URL is required when using Application Name");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckTargetUrl(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if ("remoteTestRun".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Target URL is required for remote test run");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckEndpointPattern(@AncestorInPath Item item, @QueryParameter String value) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value != null && !value.trim().isEmpty()) {
                try {
                    Pattern.compile(value);
                    return FormValidation.ok();
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regex pattern: " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckExcludeEndpointPattern(@AncestorInPath Item item, @QueryParameter String value) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value != null && !value.trim().isEmpty()) {
                try {
                    Pattern.compile(value);
                    return FormValidation.ok();
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regex pattern: " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckTestUsers(@AncestorInPath Item item, @QueryParameter String value) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value != null && !value.trim().isEmpty()) {
                String[] userArray;
                for (String user : userArray = value.split(",")) {
                    String trimmedUser = user.trim();
                    if (!trimmedUser.isEmpty()) continue;
                    return FormValidation.warning((String)"Empty test user name found. Please remove empty entries or use comma-separated format: User1,User2");
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillDataSourceItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Test User Data", "Test User Data");
            items.add("Traces", "Traces");
            return items;
        }

        public ListBoxModel doFillAppNameDataSourceItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Test User Data", "Test User Data");
            items.add("Traces", "Traces");
            return items;
        }

        public ListBoxModel doFillRunOnItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Cloud", "cloud");
            items.add("On-Premises", "on-prem");
            return items;
        }

        @RequirePOST
        public FormValidation doCheckDataSource(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            String normalized;
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if ("remoteTestRun".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Data source is required for remote test run");
            }
            if (!(value == null || value.trim().isEmpty() || "Test User Data".equalsIgnoreCase(normalized = value.trim()) || "Traces".equalsIgnoreCase(normalized))) {
                return FormValidation.error((String)"Data source must be either 'Test User Data' or 'Traces'");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckRunOn(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String executionMode) {
            String normalized;
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if ("remoteTestRun".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Run on is required for remote test run");
            }
            if (!(value == null || value.trim().isEmpty() || "cloud".equals(normalized = value.trim().toLowerCase()) || "on-prem".equals(normalized))) {
                return FormValidation.error((String)"Run on must be either 'cloud' or 'on-prem'");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillFailSeverityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None", "none");
            items.add("Low", "low");
            items.add("Medium", "medium");
            items.add("High", "high");
            items.add("Critical", "critical");
            return items;
        }

        public ListBoxModel doFillFailScopeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None", "none");
            items.add("New vulnerabilities", "new");
            items.add("Any vulnerabilities", "any");
            return items;
        }
    }
}

