/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.levo.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.levo.credentials.LevoCLICredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class LevoCLICredentialsImpl
extends BaseStandardCredentials
implements LevoCLICredentials {
    private final String organizationId;
    private final Secret authorizationKey;
    private final String baseUrl;

    @DataBoundConstructor
    public LevoCLICredentialsImpl(CredentialsScope scope, String id, String description, String organizationId, Secret authorizationKey, String baseUrl) {
        super(scope, id, description);
        this.organizationId = organizationId;
        this.authorizationKey = authorizationKey;
        this.baseUrl = baseUrl != null && !baseUrl.trim().isEmpty() ? baseUrl : "https://api.levo.ai";
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public Secret getAuthorizationKey() {
        return this.authorizationKey;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return "Levo CLI Credentials";
        }
    }
}

