/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.levo;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Plugin;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.levo.credentials.LevoCLICredentials;
import io.jenkins.plugins.levo.helpers.LevoDockerTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TestPlanBuilder
extends Builder
implements SimpleBuildStep {
    private String target;
    private String testPlan;
    private String levoCredentialsId;
    private String secretEnvironmentId;
    private Boolean generateJunitReport;
    private String extraCLIArgs;
    private String executionMode;
    private String appName;
    private String environment;
    private String categories;
    private String httpMethods;
    private String excludeMethods;
    private String endpointPattern;
    private String excludeEndpointPattern;
    private String testUsers;
    private String targetUrl;
    private String failSeverity;
    private String failScope;
    private String failThreshold;

    @DataBoundConstructor
    public TestPlanBuilder() {
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = target;
    }

    @DataBoundSetter
    public void setTestPlan(String testPlan) {
        this.testPlan = testPlan;
    }

    @DataBoundSetter
    public void setLevoCredentialsId(String levoCredentialsId) {
        this.levoCredentialsId = levoCredentialsId;
    }

    @DataBoundSetter
    public void setGenerateJunitReport(Boolean generateJunitReport) {
        this.generateJunitReport = generateJunitReport;
    }

    @DataBoundSetter
    public void setExtraCLIArgs(String extraCLIArgs) {
        this.extraCLIArgs = extraCLIArgs;
    }

    @DataBoundSetter
    public void setSecretEnvironmentId(String secretEnvironmentId) {
        this.secretEnvironmentId = secretEnvironmentId;
    }

    @DataBoundSetter
    public void setExecutionMode(String executionMode) {
        this.executionMode = executionMode;
    }

    @DataBoundSetter
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @DataBoundSetter
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @DataBoundSetter
    public void setCategories(String categories) {
        this.categories = categories;
    }

    @DataBoundSetter
    public void setHttpMethods(String httpMethods) {
        this.httpMethods = httpMethods;
    }

    @DataBoundSetter
    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    @DataBoundSetter
    public void setEndpointPattern(String endpointPattern) {
        this.endpointPattern = endpointPattern;
    }

    @DataBoundSetter
    public void setExcludeEndpointPattern(String excludeEndpointPattern) {
        this.excludeEndpointPattern = excludeEndpointPattern;
    }

    @DataBoundSetter
    public void setTestUsers(String testUsers) {
        this.testUsers = testUsers;
    }

    @DataBoundSetter
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @DataBoundSetter
    public void setFailSeverity(String failSeverity) {
        this.failSeverity = failSeverity;
    }

    @DataBoundSetter
    public void setFailScope(String failScope) {
        this.failScope = failScope;
    }

    @DataBoundSetter
    public void setFailThreshold(String failThreshold) {
        this.failThreshold = failThreshold;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTestPlan() {
        return this.testPlan;
    }

    public String getExtraCLIArgs() {
        return this.extraCLIArgs;
    }

    public String getSecretEnvironmentId() {
        return this.secretEnvironmentId;
    }

    public String getLevoCredentialsId() {
        return this.levoCredentialsId;
    }

    public Boolean getGenerateJunitReport() {
        return this.generateJunitReport;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getCategories() {
        return this.categories;
    }

    public String getHttpMethods() {
        return this.httpMethods;
    }

    public String getExcludeMethods() {
        return this.excludeMethods;
    }

    public String getEndpointPattern() {
        return this.endpointPattern;
    }

    public String getExcludeEndpointPattern() {
        return this.excludeEndpointPattern;
    }

    public String getTestUsers() {
        return this.testUsers;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String getFailSeverity() {
        return this.failSeverity;
    }

    public String getFailScope() {
        return this.failScope;
    }

    public String getFailThreshold() {
        return this.failThreshold;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        String mode;
        LevoCLICredentials credentials = (LevoCLICredentials)CredentialsProvider.findCredentialById((String)this.levoCredentialsId, LevoCLICredentials.class, run, (List)Lists.newArrayList());
        if (credentials == null) {
            listener.error("Levo Credentials not found");
            return;
        }
        String environmentFileContent = null;
        if (this.secretEnvironmentId != null && !this.secretEnvironmentId.trim().isEmpty()) {
            StringCredentials secretCredentials = (StringCredentials)CredentialsProvider.findCredentialById((String)this.secretEnvironmentId, StringCredentials.class, run, (List)Lists.newArrayList());
            if (secretCredentials == null) {
                FileCredentials secretFileCredentials = (FileCredentials)CredentialsProvider.findCredentialById((String)this.secretEnvironmentId, FileCredentials.class, run, (List)Lists.newArrayList());
                if (secretFileCredentials == null) {
                    listener.error("Defined Secret Environment not found: " + this.secretEnvironmentId);
                    run.setResult(Result.FAILURE);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(secretFileCredentials.getContent(), StandardCharsets.UTF_8));){
                    environmentFileContent = reader.lines().collect(Collectors.joining("\n"));
                }
            } else {
                environmentFileContent = secretCredentials.getSecret().getPlainText();
            }
        }
        LevoDockerTool.runLevoLogin(run, launcher, env, this.getPath(launcher, workspace), credentials.getAuthorizationKey(), credentials.getOrganizationId(), credentials.getBaseUrl());
        String string = mode = this.executionMode != null && !this.executionMode.isEmpty() ? this.executionMode : "testPlan";
        if ("appName".equals(mode)) {
            LevoDockerTool.runLevoRemoteTestRun(run, launcher, env, run.getEnvironment(listener), this.getPath(launcher, workspace), this.appName, this.environment, this.categories, this.httpMethods, this.excludeMethods, this.endpointPattern, this.excludeEndpointPattern, this.testUsers, this.targetUrl, this.failSeverity, this.failScope, this.failThreshold, credentials.getAuthorizationKey(), credentials.getOrganizationId(), credentials.getBaseUrl());
        } else {
            LevoDockerTool.runLevoTestPlan(run, launcher, env, run.getEnvironment(listener), this.getPath(launcher, workspace), this.target, this.testPlan, environmentFileContent, this.generateJunitReport, this.extraCLIArgs, this.testUsers, credentials.getOrganizationId(), credentials.getBaseUrl());
        }
    }

    private String getPath(Launcher launcher, FilePath filePath) throws IOException, InterruptedException {
        return launcher.isUnix() ? filePath.getRemote() : filePath.toURI().getPath().substring(1).replace("\\", "/");
    }

    @Symbol(value={"levo-test-plan"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(TestPlanBuilder.class);
        }

        public String getDisplayName() {
            return "Levo Test Plan";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return false;
            }
            Plugin credentialsPlugin = jenkins.getPlugin("credentials");
            if (credentialsPlugin == null) {
                return false;
            }
            return credentialsPlugin.getWrapper().isEnabled();
        }

        public ListBoxModel doFillLevoCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String levoCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(levoCredentialsId);
            }
            return CredentialsProvider.listCredentials(LevoCLICredentials.class, (Item)null, null, (List)Lists.newArrayList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(LevoCLICredentials.class));
        }

        public ListBoxModel doFillSecretEnvironmentIdItems(@AncestorInPath Item item, @QueryParameter String secretEnvironmentId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(secretEnvironmentId);
            }
            return CredentialsProvider.listCredentials(StandardCredentials.class, (Item)null, null, (List)Lists.newArrayList(), (CredentialsMatcher)CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}));
        }

        public FormValidation doCheckAppName(@QueryParameter String value, @QueryParameter String executionMode) {
            if ("appName".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Application name is required when using app-based testing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironment(@QueryParameter String value, @QueryParameter String executionMode) {
            if ("appName".equals(executionMode) && (value == null || value.trim().isEmpty())) {
                return FormValidation.error((String)"Environment is required when using app-based testing");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEndpointPattern(@QueryParameter String value) {
            if (value != null && !value.trim().isEmpty()) {
                try {
                    Pattern.compile(value);
                    return FormValidation.ok();
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regex pattern: " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExcludeEndpointPattern(@QueryParameter String value) {
            if (value != null && !value.trim().isEmpty()) {
                try {
                    Pattern.compile(value);
                    return FormValidation.ok();
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regex pattern: " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestUsers(@QueryParameter String value) {
            if (value != null && !value.trim().isEmpty()) {
                String[] userArray;
                for (String user : userArray = value.split(",")) {
                    String trimmedUser = user.trim();
                    if (!trimmedUser.isEmpty()) continue;
                    return FormValidation.warning((String)"Empty test user name found. Please remove empty entries or use comma-separated format: User1,User2");
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillFailSeverityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None", "none");
            items.add("Low", "low");
            items.add("Medium", "medium");
            items.add("High", "high");
            items.add("Critical", "critical");
            return items;
        }

        public ListBoxModel doFillFailScopeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("None", "none");
            items.add("New vulnerabilities", "new");
            items.add("Any vulnerabilities", "any");
            return items;
        }
    }
}

