/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStepExecution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class EphemeralContainerStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 5588861066775717487L;
    private final List<TemplateEnvVar> envVars = new ArrayList<TemplateEnvVar>();
    private final String image;
    private boolean alwaysPullImage = true;
    private String targetContainer;
    private String shell;
    @CheckForNull
    private List<String> command;
    @CheckForNull
    private String runAsUser;
    @CheckForNull
    private String runAsGroup;

    @DataBoundConstructor
    public EphemeralContainerStep(String image) {
        if (!PodTemplateUtils.validateImage((String)image)) {
            throw new IllegalArgumentException("Invalid container image name: '" + image + "'");
        }
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    @NonNull
    public List<TemplateEnvVar> getEnvVars() {
        return this.envVars;
    }

    @DataBoundSetter
    public void setEnvVars(List<TemplateEnvVar> envVars) {
        if (envVars != null) {
            this.envVars.clear();
            this.envVars.addAll(envVars);
        }
    }

    public String getShell() {
        return this.shell;
    }

    @DataBoundSetter
    public void setShell(String shell) {
        this.shell = Util.fixEmpty((String)shell);
    }

    public String getTargetContainer() {
        return this.targetContainer;
    }

    @DataBoundSetter
    public void setTargetContainer(String targetContainer) {
        this.targetContainer = Util.fixEmpty((String)targetContainer);
    }

    public boolean isAlwaysPullImage() {
        return this.alwaysPullImage;
    }

    @DataBoundSetter
    public void setAlwaysPullImage(boolean alwaysPullImage) {
        this.alwaysPullImage = alwaysPullImage;
    }

    @CheckForNull
    public String getRunAsUser() {
        return this.runAsUser;
    }

    @CheckForNull
    public Long getRunAsUserLong() {
        return EphemeralContainerStep.parseLong(this.runAsUser);
    }

    @DataBoundSetter
    public void setRunAsUser(@CheckForNull String runAsUser) {
        this.runAsUser = Util.fixEmpty((String)runAsUser);
    }

    @CheckForNull
    public String getRunAsGroup() {
        return this.runAsGroup;
    }

    @CheckForNull
    public Long getRunAsGroupLong() {
        return EphemeralContainerStep.parseLong(this.runAsGroup);
    }

    @DataBoundSetter
    public void setRunAsGroup(@CheckForNull String runAsGroup) {
        this.runAsGroup = Util.fixEmpty((String)runAsGroup);
    }

    @CheckForNull
    private static Long parseLong(@CheckForNull String value) {
        value = Util.fixEmptyAndTrim((String)value);
        try {
            return value == null ? null : NumberUtils.createLong((String)value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @CheckForNull
    public List<String> getCommand() {
        return this.command;
    }

    @DataBoundSetter
    public void setCommand(@CheckForNull List<String> command) {
        this.command = command;
    }

    @DataBoundSetter
    @Deprecated
    public void setCommandLine(@CheckForNull String command) {
        this.setCommand(PodTemplateUtils.splitCommandLine((String)command));
    }

    @CheckForNull
    public String getCommandLine() {
        return this.command == null ? null : StringUtils.join(this.command, (String)" ");
    }

    public StepExecution start(StepContext context) {
        return new EphemeralContainerStepExecution(this, context);
    }

    public static class DeprecatedEphemeralContainerStep
    extends EphemeralContainerStep {
        private static final long serialVersionUID = -373177686635087038L;

        @DataBoundConstructor
        public DeprecatedEphemeralContainerStep(String image) {
            super(image);
        }

        @Extension
        public static class DescriptorImpl
        extends io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep$DescriptorImpl {
            @Override
            public String getFunctionName() {
                return "ephemeralContainer";
            }

            public boolean isAdvanced() {
                return true;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withEphemeralContainer";
        }

        @NonNull
        public String getDisplayName() {
            return "Define an Ephemeral Container to add to the current Pod";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Node.class, FilePath.class, Run.class, Launcher.class, TaskListener.class);
        }

        public FormValidation doCheckImage(@QueryParameter String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.error((String)"Image is mandatory");
            }
            if (PodTemplateUtils.validateImage((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Malformed image");
        }

        public FormValidation doCheckTargetContainer(@QueryParameter String value) {
            if (PodTemplateUtils.validateContainerName((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid container name");
        }

        public FormValidation doCheckRunAsUser(@QueryParameter String value) {
            return DescriptorImpl.validRunAsId(value);
        }

        public FormValidation doCheckRunAsGroup(@QueryParameter String value) {
            return DescriptorImpl.validRunAsId(value);
        }

        private static FormValidation validRunAsId(String value) {
            if ((value = Util.fixEmpty((String)value)) == null) {
                return FormValidation.ok();
            }
            try {
                long v = Long.parseLong(value);
                if (v < 0L) {
                    return FormValidation.error((String)"Must be greater than 0");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException ignore) {
                return FormValidation.error((String)"Invalid number");
            }
        }
    }
}

