/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep;
import java.util.Optional;

public abstract class EphemeralContainerStepRule
extends AbstractDescribableImpl<EphemeralContainerStepRule>
implements ExtensionPoint {
    @NonNull
    public abstract Optional<Result> test(@NonNull EphemeralContainerStep var1);

    public static class Result {
        private final Action action;
        private final String reason;

        @NonNull
        public static Result reject(@Nullable String reason) {
            return new Result(Action.REJECT, reason);
        }

        public Result(@NonNull Action action) {
            this(action, null);
        }

        public Result(@NonNull Action action, @Nullable String reason) {
            this.action = action;
            this.reason = reason;
        }

        @NonNull
        public Action getAction() {
            return this.action;
        }

        @NonNull
        public Optional<String> getReason() {
            return Optional.ofNullable(this.reason);
        }
    }

    public static enum Action {
        ALLOW("Allow"),
        REJECT("Reject");

        private final String description;

        private Action(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

