/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import com.codahale.metrics.MetricRegistry;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import hudson.util.Iterators;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerExecDecorator;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerGlobalConfiguration;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerKubernetesCloudTrait;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerMonitor;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStep;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerStepRuleEvaluator;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralPodContainerSource;
import io.jenkins.plugins.kubernetes.ephemeral.KubernetesClientModelFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.Resources;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class EphemeralContainerStepExecution
extends GeneralNonBlockingStepExecution {
    private static final long serialVersionUID = 7634132798345235774L;
    private static final Logger LOGGER = Logger.getLogger(EphemeralContainerStepExecution.class.getName());
    private static final int PATCH_MAX_RETRY = Integer.getInteger(EphemeralContainerStepExecution.class.getName() + ".patchMaxRetry", 10);
    private static final int PATCH_RETRY_MAX_WAIT = Integer.getInteger(EphemeralContainerStepExecution.class.getName() + ".patchRetryMaxWaitSecs", 2);
    private static final int START_MAX_RETRY = Integer.getInteger(EphemeralContainerStepExecution.class.getName() + ".startMaxRetry", 3);
    private static final int START_RETRY_MAX_WAIT = Integer.getInteger(EphemeralContainerStepExecution.class.getName() + ".startRetryMaxWaitSecs", 2);
    private static final Set<String> START_RETRY_REASONS = Collections.singleton("StartError");
    private static final int WHOAMI_TIMEOUT = Integer.getInteger(EphemeralContainerStepExecution.class.getName() + ".whoamiTimeoutSecs", 180);
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient EphemeralContainerStep step;
    @CheckForNull
    private ContainerExecDecorator decorator;

    EphemeralContainerStepExecution(@NonNull EphemeralContainerStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(this.getContext());
        KubernetesSlave slave = nodeContext.getKubernetesSlave();
        KubernetesCloud cloud = slave.getKubernetesCloud();
        EphemeralContainerKubernetesCloudTrait trait = (EphemeralContainerKubernetesCloudTrait)((Object)cloud.getTrait(EphemeralContainerKubernetesCloudTrait.class).orElseThrow(() -> new AbortException("Ephemeral containers not enabled on " + cloud.getDisplayName())));
        EphemeralContainerGlobalConfiguration globalConfig = EphemeralContainerGlobalConfiguration.get();
        Iterable rules = Iterators.sequence((Iterable[])new Iterable[]{trait.getContainerStepRules(), globalConfig.getContainerStepRules()});
        EphemeralContainerStepRuleEvaluator evaluator = new EphemeralContainerStepRuleEvaluator();
        evaluator.eval(this.step, rules);
        this.run(this::startEphemeralContainerWithRetry);
        return false;
    }

    protected void startEphemeralContainerWithRetry() throws Exception {
        StepContext context = this.getContext();
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(context);
        KubernetesSlave slave = nodeContext.getKubernetesSlave();
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        MetricRegistry metrics = Metrics.metricRegistry();
        int retries = 0;
        while (true) {
            try {
                this.startEphemeralContainer();
            }
            catch (EphemeralContainerTerminatedException e) {
                String reason = e.getState().getReason();
                if (retries < START_MAX_RETRY && START_RETRY_REASONS.contains(reason)) {
                    metrics.counter("kubernetes.cloud.containers.ephemeral.creation.retried").inc();
                    ++retries;
                    long waitTime = 0L;
                    if (START_RETRY_MAX_WAIT > 0) {
                        waitTime = ThreadLocalRandom.current().nextLong(TimeUnit.SECONDS.toMillis(START_RETRY_MAX_WAIT));
                    }
                    if (waitTime > 0L) {
                        LOGGER.info("Ephemeral container terminated while starting with reason " + reason + ", trying again in " + waitTime + "ms (" + retries + " of " + START_MAX_RETRY + "): " + e.getMessage());
                        Thread.sleep(waitTime);
                    } else {
                        LOGGER.info("Ephemeral container terminated while starting with reason " + reason + ", trying again (" + retries + " of " + START_MAX_RETRY + "): " + e.getMessage());
                    }
                    if (listener == null) continue;
                    listener.getLogger().println("Ephemeral container terminated while starting with reason " + reason + ", trying again (" + retries + " of " + START_MAX_RETRY + ")");
                    continue;
                }
                if (listener != null && StringUtils.contains((CharSequence)e.getState().getMessage(), (CharSequence)"failed to create shim task: context")) {
                    listener.getLogger().println("Based on the container termination message there are several reasons that could have caused the failure:\n  Resource Constraints:\n    - Insufficient memory or CPU resources\n    - Resource limits being hit during startup\n    - Node pressure or high system load");
                }
                LOGGER.log(Level.FINEST, "Ephemeral container failed to start after " + retries + " retries", (Throwable)((Object)e));
                throw new AbortException("Ephemeral container " + e.getContainerName() + " on Pod " + slave.getPodName() + " failed to start: " + e.getMessage());
            }
            break;
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="misbehaving logger plugins should not stop prevent container termination")
    private void startEphemeralContainer() throws Exception {
        LOGGER.log(Level.FINE, "Starting ephemeral container step.");
        StepContext context = this.getContext();
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(context);
        KubernetesSlave slave = nodeContext.getKubernetesSlave();
        KubernetesCloud cloud = slave.getKubernetesCloud();
        String stepId = ObjectUtils.hashCodeHex((Object)this.step);
        String containerName = PodUtils.createNameWithRandomSuffix((String)("jkns-step-" + stepId));
        EphemeralContainer ec = this.createEphemeralContainer(containerName, slave);
        LOGGER.finest(() -> "Adding Ephemeral Container: " + String.valueOf(ec));
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        String containerUrl = ModelHyperlinkNote.encodeTo((String)("/computer/" + nodeContext.getPodName() + "/container?name=" + containerName), (String)containerName);
        if (listener != null) {
            String runningAs = "";
            SecurityContext sc = ec.getSecurityContext();
            if (sc != null) {
                runningAs = String.format(" (running as %s:%s)", sc.getRunAsUser(), sc.getRunAsGroup());
            }
            try {
                listener.getLogger().println("Starting ephemeral container " + containerUrl + " with image " + ec.getImage() + runningAs);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        PodResource podResource = nodeContext.getPodResource();
        MetricRegistry metrics = Metrics.metricRegistry();
        StopWatch startDuration = new StopWatch();
        startDuration.start();
        int retries = 0;
        try {
            while (true) {
                try {
                    podResource.ephemeralContainers().edit(pod -> ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().addToEphemeralContainers(new EphemeralContainer[]{ec})).endSpec()).build());
                }
                catch (KubernetesClientException kce) {
                    Status status = kce.getStatus();
                    if (retries < PATCH_MAX_RETRY && status != null && StringUtils.equals((CharSequence)status.getReason(), (CharSequence)"Conflict")) {
                        ++retries;
                        long waitTime = 0L;
                        if (status.getDetails() != null && status.getDetails().getRetryAfterSeconds() != null) {
                            waitTime = TimeUnit.SECONDS.toMillis(status.getDetails().getRetryAfterSeconds().intValue());
                        } else if (PATCH_RETRY_MAX_WAIT > 0) {
                            waitTime = ThreadLocalRandom.current().nextLong(TimeUnit.SECONDS.toMillis(PATCH_RETRY_MAX_WAIT));
                        }
                        if (waitTime > 0L) {
                            LOGGER.info("Ephemeral container patch failed due to optimistic locking, trying again in " + waitTime + "ms (" + retries + " of " + PATCH_MAX_RETRY + "): " + kce.getMessage());
                            Thread.sleep(waitTime);
                            continue;
                        }
                        LOGGER.info("Ephemeral container patch failed due to optimistic locking, trying again (" + retries + " of " + PATCH_MAX_RETRY + "): " + kce.getMessage());
                        continue;
                    }
                    throw kce;
                }
                break;
            }
        }
        catch (KubernetesClientException kce) {
            metrics.counter("kubernetes.cloud.containers.ephemeral.creation.failed").inc();
            LOGGER.log(Level.WARNING, "Failed to add ephemeral container " + containerName + " to pod " + slave.getPodName() + " on cloud " + cloud.name + " after " + retries + " retries.", kce);
            Object message = "Ephemeral container could not be added.";
            Status status = kce.getStatus();
            if (status != null) {
                if (status.getMessage() != null) {
                    message = (String)message + " " + status.getMessage();
                }
                message = (String)message + " (" + status.getReason() + ")";
            }
            if (retries == PATCH_MAX_RETRY) {
                message = (String)message + ". Reached max retry limit.";
            }
            throw new AbortException((String)message);
        }
        PodTemplate pt = slave.getTemplate();
        LOGGER.fine(() -> "Waiting for Ephemeral Container to start: " + containerName + " on Pod " + slave.getPodName());
        try {
            StopWatch waitDuration = new StopWatch();
            waitDuration.start();
            podResource.waitUntilCondition((Predicate)new EphemeralContainerRunningCondition(containerName, containerUrl, listener), (long)pt.getSlaveConnectTimeout(), TimeUnit.SECONDS);
            LOGGER.fine(() -> "Ephemeral Container started: " + containerName + " on Pod " + slave.getPodName() + " (waited " + String.valueOf(waitDuration) + ")");
            metrics.counter("kubernetes.cloud.containers.ephemeral.created").inc();
            metrics.histogram("kubernetes.cloud.containers.ephemeral.creation.wait.duration").update(waitDuration.getTime());
        }
        catch (KubernetesClientException kce) {
            metrics.counter("kubernetes.cloud.containers.ephemeral.creation.failed").inc();
            if (kce instanceof EphemeralContainerTerminatedException) {
                throw kce;
            }
            if (kce instanceof KubernetesClientTimeoutException) {
                String status;
                try {
                    status = EphemeralPodContainerSource.getEphemeralContainerStatus((Pod)podResource.get(), containerName).map(cs -> cs.getState().toString()).orElse("no status available");
                }
                catch (KubernetesClientException ignored) {
                    status = "failed to get status";
                }
                throw new AbortException("Ephemeral container " + containerName + " on Pod " + slave.getPodName() + " failed to start after " + pt.getSlaveConnectTimeout() + " seconds: " + status);
            }
            Throwable cause = kce.getCause();
            if (cause instanceof InterruptedException) {
                LOGGER.log(Level.FINEST, "Ephemeral container step interrupted " + containerName + " on Pod " + slave.getPodName(), kce);
                return;
            }
            LOGGER.log(Level.FINEST, "Ephemeral container " + containerName + " on Pod " + slave.getPodName() + " failed to start due to kubernetes client exception", kce);
            throw new AbortException("Ephemeral container " + containerName + " on Pod " + slave.getPodName() + " failed to start: " + kce.getMessage());
        }
        metrics.histogram("kubernetes.cloud.containers.ephemeral.creation.duration").update(startDuration.getTime());
        EnvironmentExpander env = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Collections.singletonMap("POD_CONTAINER", containerName)));
        EnvVars globalVars = null;
        Jenkins instance = Jenkins.get();
        DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
        List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
        if (envVarsNodePropertyList != null && !envVarsNodePropertyList.isEmpty()) {
            globalVars = ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
        }
        EnvVars rcEnvVars = null;
        Run run = (Run)context.get(Run.class);
        if (run != null && listener != null) {
            rcEnvVars = run.getEnvironment(listener);
        }
        this.decorator = new EphemeralContainerExecDecorator();
        this.decorator.setNodeContext(nodeContext);
        this.decorator.setContainerName(containerName);
        this.decorator.setEnvironmentExpander(env);
        this.decorator.setGlobalVars(globalVars);
        this.decorator.setRunContextEnvVars(rcEnvVars);
        this.decorator.setShell(this.step.getShell());
        context.newBodyInvoker().withContexts(new Object[]{BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)context.get(LauncherDecorator.class)), (LauncherDecorator)this.decorator), env}).withCallback(Resources.closeQuietlyCallback((Closeable[])new Closeable[]{this.decorator})).withCallback((BodyExecutionCallback)new TerminateEphemeralContainerExecCallback(containerName)).start();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="decorator is null checked and context is marked non-null")
    public void stop(@NonNull Throwable cause) throws Exception {
        LOGGER.finest("Stopping ephemeral container step.");
        super.stop(cause);
        if (this.decorator != null) {
            StepContext context = this.getContext();
            Resources.closeQuietly((StepContext)context, (Closeable[])new Closeable[]{this.decorator});
            EphemeralContainerStepExecution.terminateEphemeralContainer(context, this.decorator.getContainerName());
        }
    }

    private EphemeralContainer createEphemeralContainer(String containerName, KubernetesSlave slave) throws IOException, InterruptedException {
        Pod pod = (Pod)slave.getPod().orElseThrow(() -> new AbortException("Kubernetes node Pod reference not found."));
        EphemeralContainer ec = KubernetesClientModelFactory.createEphemeralContainer(containerName, this.step, pod);
        SecurityContext sc = ec.getSecurityContext();
        if (sc == null || sc.getRunAsUser() == null && sc.getRunAsGroup() == null) {
            if (sc == null) {
                sc = new SecurityContext();
                ec.setSecurityContext(sc);
            }
            this.setDefaultRunAsUser(sc);
        }
        return ec;
    }

    private void setDefaultRunAsUser(SecurityContext sc) throws IOException, InterruptedException {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        if (launcher != null && launcher.isUnix()) {
            ByteArrayOutputStream userId = new ByteArrayOutputStream();
            launcher.launch().cmds(new String[]{"id", "-u"}).quiet(true).stdout((OutputStream)userId).start().joinWithTimeout((long)WHOAMI_TIMEOUT, TimeUnit.SECONDS, launcher.getListener());
            ByteArrayOutputStream groupId = new ByteArrayOutputStream();
            launcher.launch().cmds(new String[]{"id", "-g"}).quiet(true).stdout((OutputStream)groupId).start().joinWithTimeout((long)WHOAMI_TIMEOUT, TimeUnit.SECONDS, launcher.getListener());
            Charset charset = Charset.defaultCharset();
            sc.setRunAsUser(NumberUtils.createLong((String)userId.toString(charset).trim()));
            sc.setRunAsGroup(NumberUtils.createLong((String)groupId.toString(charset).trim()));
        }
    }

    private static void terminateEphemeralContainer(StepContext context, String containerName) throws Exception {
        LOGGER.fine(() -> "Removing ephemeral container: " + containerName);
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(context);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PodResource resource = nodeContext.getPodResource();
        try (ExecWatch ignored = ((ContainerResource)resource.inContainer((Object)containerName)).redirectingInput().writingOutput((OutputStream)out).writingError((OutputStream)out).withTTY().exec(EphemeralContainerMonitor.containerStopCommand(containerName));){
            resource.waitUntilCondition((Predicate)new EphemeralContainerStatusCondition(containerName, false), 10L, TimeUnit.SECONDS);
            LOGGER.finest(() -> "Ephemeral Container stopped: " + nodeContext.getPodName() + "/" + containerName);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to terminate ephemeral container " + containerName + " on pod " + nodeContext.getPodName(), ex);
        }
        LOGGER.finest(() -> {
            try {
                ContainerStatus status = EphemeralPodContainerSource.getEphemeralContainerStatus((Pod)resource.get(), containerName).orElse(null);
                return "Ephemeral container status after step: " + nodeContext.getPodName() + "/" + containerName + " -> " + String.valueOf(status);
            }
            catch (KubernetesClientException ignored) {
                return "Failed to get container status after step";
            }
        });
    }

    private static class EphemeralContainerTerminatedException
    extends KubernetesClientException {
        private static final long serialVersionUID = 3455221650416693019L;
        private final String containerName;
        private final ContainerStateTerminated state;

        EphemeralContainerTerminatedException(@NonNull String containerName, @NonNull ContainerStateTerminated state) {
            super("container terminated while waiting to start: " + String.valueOf(state));
            this.containerName = containerName;
            this.state = state;
        }

        public ContainerStateTerminated getState() {
            return this.state;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }

    private static class EphemeralContainerRunningCondition
    extends EphemeralContainerStatusCondition {
        private static final Set<String> IGNORE_REASONS = Set.of("ContainerCreating", "PodInitializing");
        @CheckForNull
        private final TaskListener taskListener;
        private final String containerUrl;

        EphemeralContainerRunningCondition(String containerName, String containerUrl, @CheckForNull TaskListener listener) {
            super(containerName, true);
            this.containerUrl = containerUrl;
            this.taskListener = listener;
        }

        @Override
        protected void onStatus(ContainerStatus status) {
            ContainerStateWaiting waiting;
            ContainerStateTerminated terminated = status.getState().getTerminated();
            if (terminated != null) {
                if (this.taskListener != null) {
                    PrintStream logger = this.taskListener.getLogger();
                    logger.println("Ephemeral container " + this.containerUrl + " failed to start: " + terminated.getMessage() + " (" + terminated.getReason() + ")");
                }
                throw new EphemeralContainerTerminatedException(this.containerName, terminated);
            }
            if (this.taskListener != null && (waiting = status.getState().getWaiting()) != null && !IGNORE_REASONS.contains(waiting.getReason())) {
                StringBuilder logMsg = new StringBuilder().append("Ephemeral container ").append(this.containerUrl);
                String message = waiting.getMessage();
                if (message != null) {
                    logMsg.append(" ").append(message);
                }
                logMsg.append(" (").append(waiting.getReason()).append(")");
                this.taskListener.getLogger().println(logMsg);
            }
        }
    }

    private static class TerminateEphemeralContainerExecCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6385838254761750483L;
        private final String containerName;

        private TerminateEphemeralContainerExecCallback(String containerName) {
            this.containerName = containerName;
        }

        public void finished(StepContext context) throws Exception {
            EphemeralContainerStepExecution.terminateEphemeralContainer(context, this.containerName);
        }
    }

    private static class EphemeralContainerStatusCondition
    implements Predicate<Pod> {
        protected final String containerName;
        private final boolean running;

        EphemeralContainerStatusCondition(String containerName, boolean running) {
            this.containerName = containerName;
            this.running = running;
        }

        @Override
        public boolean test(Pod pod) {
            if (pod == null) {
                return !this.running;
            }
            return pod.getStatus().getEphemeralContainerStatuses().stream().filter(status -> StringUtils.equals((CharSequence)status.getName(), (CharSequence)this.containerName)).anyMatch(status -> {
                this.onStatus((ContainerStatus)status);
                if (this.running) {
                    return status.getState().getRunning() != null;
                }
                return status.getState().getTerminated() != null;
            });
        }

        protected void onStatus(ContainerStatus status) {
        }
    }
}

