/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.kubernetes.ephemeral.EphemeralContainerKubernetesCloudTrait;
import java.io.IOException;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;

public class EphemeralContainerKubernetesComputer
extends KubernetesComputer {
    public EphemeralContainerKubernetesComputer(KubernetesSlave slave) {
        super(slave);
    }

    @NonNull
    public EnvVars buildEnvironment(@NonNull TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = super.buildEnvironment(listener);
        KubernetesSlave slave = (KubernetesSlave)this.getNode();
        if (slave != null) {
            KubernetesCloud cloud = slave.getKubernetesCloud();
            boolean hasTrait = cloud.getTrait(EphemeralContainerKubernetesCloudTrait.class).isPresent();
            envVars.put("KUBERNETES_CLOUD_EPHEMERAL_CONTAINERS_ENABLED", Boolean.toString(hasTrait));
        }
        return envVars;
    }
}

