/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.kobiton.ApiEndpoint;
import io.jenkins.plugins.kobiton.AppUploaderBuilder;
import io.jenkins.plugins.kobiton.CredentialsBuildWrapper;
import io.jenkins.plugins.kobiton.Messages;
import io.jenkins.plugins.kobiton.services.user.DefaultUserService;
import io.jenkins.plugins.kobiton.shared.logger.PluginLogger;
import io.jenkins.plugins.kobiton.shared.models.Credential;
import io.jenkins.plugins.kobiton.shared.utils.StringUtils;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Symbol(value={"credentialsBuildWrapper"})
@Extension
public class CredentialsBuildWrapperDescriptor
extends BuildWrapperDescriptor {
    DefaultUserService userService = new DefaultUserService();

    public CredentialsBuildWrapperDescriptor() {
        super(CredentialsBuildWrapper.class);
        this.load();
    }

    @NonNull
    public String getDisplayName() {
        return Messages.BuildEnvironment_DisplayName();
    }

    public boolean isApplicable(AbstractProject<?, ?> item) {
        return true;
    }

    public CredentialsBuildWrapper newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        return new CredentialsBuildWrapper(formData.getString("username"), Secret.fromString((String)formData.getString("apiKey")), formData.getString("standaloneUrl"));
    }

    public FormValidation doCheckUsername(@QueryParameter String username) {
        return StringUtils.isNullOrEmpty(username) ? FormValidation.error((String)Messages.BuildEnvironment_error_missingUsername()) : FormValidation.ok();
    }

    public FormValidation doCheckApiKey(@QueryParameter String apiKey) {
        return StringUtils.isNullOrEmpty(apiKey) ? FormValidation.error((String)Messages.BuildEnvironment_error_missingApiKey()) : FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doAuthenticateUser(@QueryParameter(value="username") String username, @QueryParameter(value="apiKey") String apiKey, @QueryParameter(value="standaloneUrl") String standaloneUrl) {
        if (StringUtils.isNullOrEmpty(username) || StringUtils.isNullOrEmpty(apiKey)) {
            return FormValidation.error((String)Messages.BuildEnvironment_error_missingCredential());
        }
        ApiEndpoint.getInstance().setBaseUrl(standaloneUrl);
        try {
            boolean isUserDisabled = this.userService.isUserDisabled(new Credential(username, apiKey));
            if (isUserDisabled) {
                return FormValidation.error((String)Messages.BuildEnvironment_auth_fail());
            }
            return FormValidation.ok((String)Messages.BuildEnvironment_auth_success());
        }
        catch (Exception e) {
            PluginLogger.debug("Error while validating: " + e.getMessage(), AppUploaderBuilder.class.getName());
            return FormValidation.ok((String)Messages.BuildEnvironment_auth_fail());
        }
    }
}

