/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import io.jenkins.plugins.kobiton.ApiEndpoint;
import io.jenkins.plugins.kobiton.shared.models.Credential;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

public class CredentialsBuildWrapper
extends SimpleBuildWrapper {
    private final Credential credential;
    private final String standaloneUrl;

    @DataBoundConstructor
    public CredentialsBuildWrapper(String username, Secret apiKey, String standaloneUrl) {
        this.credential = new Credential(username, apiKey);
        this.standaloneUrl = standaloneUrl;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getUsername() {
        return this.credential.getUsername();
    }

    public String getApiKey() {
        return this.credential.getApiKey();
    }

    public String getStandaloneUrl() {
        return this.standaloneUrl;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) {
        context.env("USERNAME", this.getUsername());
        context.env("API_KEY", this.getApiKey());
        ApiEndpoint.getInstance().setBaseUrl(this.getStandaloneUrl());
    }
}

