// CHECKSTYLE:OFF

package io.jenkins.plugins.kobiton;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildEnvironment.error.missingCredential}: {@code Username

     * and API key cannot be empty}.
     * 
     * @return
     *     {@code Username and API key cannot be empty}
     */
    public static String BuildEnvironment_error_missingCredential() {
        return holder.format("BuildEnvironment.error.missingCredential");
    }

    /**
     * Key {@code BuildEnvironment.error.missingCredential}: {@code Username

     * and API key cannot be empty}.
     * 
     * @return
     *     {@code Username and API key cannot be empty}
     */
    public static Localizable _BuildEnvironment_error_missingCredential() {
        return new Localizable(holder, "BuildEnvironment.error.missingCredential");
    }

    /**
     * Key {@code BuildEnvironment.auth.fail}: {@code Unauthorized}.
     * 
     * @return
     *     {@code Unauthorized}
     */
    public static String BuildEnvironment_auth_fail() {
        return holder.format("BuildEnvironment.auth.fail");
    }

    /**
     * Key {@code BuildEnvironment.auth.fail}: {@code Unauthorized}.
     * 
     * @return
     *     {@code Unauthorized}
     */
    public static Localizable _BuildEnvironment_auth_fail() {
        return new Localizable(holder, "BuildEnvironment.auth.fail");
    }

    /**
     * Key {@code UploadApp.error.fileNotFound}: {@code Uploading file does

     * not exist}.
     * 
     * @return
     *     {@code Uploading file does not exist}
     */
    public static String UploadApp_error_fileNotFound() {
        return holder.format("UploadApp.error.fileNotFound");
    }

    /**
     * Key {@code UploadApp.error.fileNotFound}: {@code Uploading file does

     * not exist}.
     * 
     * @return
     *     {@code Uploading file does not exist}
     */
    public static Localizable _UploadApp_error_fileNotFound() {
        return new Localizable(holder, "UploadApp.error.fileNotFound");
    }

    /**
     * Key {@code BuildEnvironment.error.missingApiKey}: {@code API key

     * cannot be empty}.
     * 
     * @return
     *     {@code API key cannot be empty}
     */
    public static String BuildEnvironment_error_missingApiKey() {
        return holder.format("BuildEnvironment.error.missingApiKey");
    }

    /**
     * Key {@code BuildEnvironment.error.missingApiKey}: {@code API key

     * cannot be empty}.
     * 
     * @return
     *     {@code API key cannot be empty}
     */
    public static Localizable _BuildEnvironment_error_missingApiKey() {
        return new Localizable(holder, "BuildEnvironment.error.missingApiKey");
    }

    /**
     * Key {@code BuildEnvironment.auth.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String BuildEnvironment_auth_success() {
        return holder.format("BuildEnvironment.auth.success");
    }

    /**
     * Key {@code BuildEnvironment.auth.success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _BuildEnvironment_auth_success() {
        return new Localizable(holder, "BuildEnvironment.auth.success");
    }

    /**
     * Key {@code UploadApp.error.fileUnsupportedFileExtension}: {@code

     * Unsupported file extension}.
     * 
     * @return
     *     {@code Unsupported file extension}
     */
    public static String UploadApp_error_fileUnsupportedFileExtension() {
        return holder.format("UploadApp.error.fileUnsupportedFileExtension");
    }

    /**
     * Key {@code UploadApp.error.fileUnsupportedFileExtension}: {@code

     * Unsupported file extension}.
     * 
     * @return
     *     {@code Unsupported file extension}
     */
    public static Localizable _UploadApp_error_fileUnsupportedFileExtension() {
        return new Localizable(holder, "UploadApp.error.fileUnsupportedFileExtension");
    }

    /**
     * Key {@code BuildEnvironment.DisplayName}: {@code Kobiton}.
     * 
     * @return
     *     {@code Kobiton}
     */
    public static String BuildEnvironment_DisplayName() {
        return holder.format("BuildEnvironment.DisplayName");
    }

    /**
     * Key {@code BuildEnvironment.DisplayName}: {@code Kobiton}.
     * 
     * @return
     *     {@code Kobiton}
     */
    public static Localizable _BuildEnvironment_DisplayName() {
        return new Localizable(holder, "BuildEnvironment.DisplayName");
    }

    /**
     * Key {@code UploadApp.error.missingUploadPath}: {@code Path cannot be

     * empty when uploading file}.
     * 
     * @return
     *     {@code Path cannot be empty when uploading file}
     */
    public static String UploadApp_error_missingUploadPath() {
        return holder.format("UploadApp.error.missingUploadPath");
    }

    /**
     * Key {@code UploadApp.error.missingUploadPath}: {@code Path cannot be

     * empty when uploading file}.
     * 
     * @return
     *     {@code Path cannot be empty when uploading file}
     */
    public static Localizable _UploadApp_error_missingUploadPath() {
        return new Localizable(holder, "UploadApp.error.missingUploadPath");
    }

    /**
     * Key {@code BuildEnvironment.error.missingUsername}: {@code Username

     * cannot be empty}.
     * 
     * @return
     *     {@code Username cannot be empty}
     */
    public static String BuildEnvironment_error_missingUsername() {
        return holder.format("BuildEnvironment.error.missingUsername");
    }

    /**
     * Key {@code BuildEnvironment.error.missingUsername}: {@code Username

     * cannot be empty}.
     * 
     * @return
     *     {@code Username cannot be empty}
     */
    public static Localizable _BuildEnvironment_error_missingUsername() {
        return new Localizable(holder, "BuildEnvironment.error.missingUsername");
    }

    /**
     * Key {@code UploadApp.DisplayName}: {@code Upload application to

     * Kobiton Apps Repository}.
     * 
     * @return
     *     {@code Upload application to Kobiton Apps Repository}
     */
    public static String UploadApp_DisplayName() {
        return holder.format("UploadApp.DisplayName");
    }

    /**
     * Key {@code UploadApp.DisplayName}: {@code Upload application to

     * Kobiton Apps Repository}.
     * 
     * @return
     *     {@code Upload application to Kobiton Apps Repository}
     */
    public static Localizable _UploadApp_DisplayName() {
        return new Localizable(holder, "UploadApp.DisplayName");
    }

}
