/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton.shared.utils;

import io.jenkins.plugins.kobiton.shared.models.Credential;
import io.jenkins.plugins.kobiton.shared.utils.CredentialUtils;
import java.net.URI;
import java.net.http.HttpRequest;

public final class HttpUtils {
    private HttpUtils() {
        throw new IllegalStateException("Utils class");
    }

    public static HttpRequest.Builder createAuthHeader(String url, Credential credential) {
        return HttpRequest.newBuilder(URI.create(url)).header("Authorization", "Basic " + CredentialUtils.encodeCredentials(credential));
    }

    public static HttpRequest createGetRequest(String url, Credential credential) {
        return HttpUtils.createAuthHeader(url, credential).GET().build();
    }

    public static HttpRequest createPostRequest(String url, Credential credential, String body) {
        return HttpUtils.createAuthHeader(url, credential).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
    }

    public static HttpRequest createPutRequest(String url, byte[] fileContent) {
        return HttpRequest.newBuilder(URI.create(url)).header("x-amz-tagging", "unsaved=true").header("Content-Type", "application/octet-stream").PUT(HttpRequest.BodyPublishers.ofByteArray(fileContent)).build();
    }
}

