/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton.shared.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.plugins.kobiton.shared.constants.Constants;
import java.text.MessageFormat;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Application {
    private Integer appId;
    private final Integer versionId;

    @JsonCreator
    public Application(@JsonProperty(value="appId") Integer appId, @JsonProperty(value="versionId") Integer versionId) {
        this.appId = appId;
        this.versionId = versionId;
    }

    public Integer appId() {
        return this.appId;
    }

    public Integer versionId() {
        return this.versionId;
    }

    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return Objects.equals(this.appId, that.appId()) && Objects.equals(this.versionId, that.versionId());
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.versionId);
    }

    public String toString() {
        if (this.appId == null) {
            return "{versionId='" + this.versionId + "'}";
        }
        return "{appId='" + this.appId + "', versionId='" + this.versionId + "'}";
    }

    public String getAppOrVersionId() {
        if (this.appId != null) {
            return MessageFormat.format(Constants.APP_ID_MAPPING, this.appId.toString());
        }
        return MessageFormat.format(Constants.APP_VERSION_ID_MAPPING, this.versionId.toString());
    }
}

