/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton.services.user;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jenkins.plugins.kobiton.ApiEndpoint;
import io.jenkins.plugins.kobiton.services.HttpService;
import io.jenkins.plugins.kobiton.services.user.UserService;
import io.jenkins.plugins.kobiton.shared.models.Credential;
import io.jenkins.plugins.kobiton.shared.models.User;
import java.io.IOException;

public class DefaultUserService
implements UserService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpService httpService = new HttpService.Builder().build();

    @Override
    public String getUrl(String endpoint) {
        return ApiEndpoint.getInstance().getBaseUrl() + endpoint;
    }

    private static User toUser(String response) throws IOException {
        return (User)OBJECT_MAPPER.readValue(response, User.class);
    }

    public User getUser(Credential credential) throws IOException {
        String response = this.httpService.get(this.getUrl(CURRENT_USER_URL), credential);
        return DefaultUserService.toUser(response);
    }

    public boolean isUserDisabled(Credential credential) throws IOException {
        User user = this.getUser(credential);
        return user.disabled();
    }
}

