/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton.services.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jenkins.plugins.kobiton.ApiEndpoint;
import io.jenkins.plugins.kobiton.services.HttpService;
import io.jenkins.plugins.kobiton.services.app.AppService;
import io.jenkins.plugins.kobiton.shared.models.ApiVariable;
import io.jenkins.plugins.kobiton.shared.models.Application;
import io.jenkins.plugins.kobiton.shared.models.Credential;
import io.jenkins.plugins.kobiton.shared.models.PreSignedURL;
import io.jenkins.plugins.kobiton.shared.utils.MappingUtils;
import java.io.IOException;

public class AppUploaderService
implements AppService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpService httpService = new HttpService.Builder().build();

    @Override
    public String getUrl(String endpoint) {
        return ApiEndpoint.getInstance().getBaseUrl() + endpoint;
    }

    public PreSignedURL generatePreSignedUploadURL(Credential credential, String fileName, Integer appId) throws IOException {
        ObjectNode requestBodyObject = OBJECT_MAPPER.createObjectNode();
        requestBodyObject.put(ApiVariable.FILE_NAME, fileName);
        if (appId != null) {
            requestBodyObject.put(ApiVariable.APP_ID, appId);
        }
        String requestBody = OBJECT_MAPPER.writeValueAsString((Object)requestBodyObject);
        String response = this.httpService.post(this.getUrl(APP_UPLOAD_URL), credential, requestBody);
        return MappingUtils.mapResponseToObject(response, PreSignedURL.class, OBJECT_MAPPER);
    }

    public Boolean uploadFileToS3(String preSignedUrl, String uploadPath) throws IOException {
        this.httpService.put(preSignedUrl, uploadPath);
        return Boolean.TRUE;
    }

    public Application createApplication(Credential credential, String fileName, String appPath) throws IOException {
        ObjectNode requestBodyObject = OBJECT_MAPPER.createObjectNode();
        requestBodyObject.put(ApiVariable.FILE_NAME, fileName);
        requestBodyObject.put(ApiVariable.APP_PATH, appPath);
        String requestBody = OBJECT_MAPPER.writeValueAsString((Object)requestBodyObject);
        String response = this.httpService.post(this.getUrl(APP_BASE_URL), credential, requestBody);
        return MappingUtils.mapResponseToObject(response, Application.class, OBJECT_MAPPER);
    }
}

