/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kobiton;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import io.jenkins.plugins.kobiton.VariableInjectorAction;
import io.jenkins.plugins.kobiton.services.app.AppUploaderService;
import io.jenkins.plugins.kobiton.shared.logger.PluginLogger;
import io.jenkins.plugins.kobiton.shared.models.Application;
import io.jenkins.plugins.kobiton.shared.models.Credential;
import io.jenkins.plugins.kobiton.shared.models.PreSignedURL;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class AppUploaderBuilder
extends Builder
implements SimpleBuildStep {
    private final String uploadPath;
    private final Integer appId;
    private final Boolean isUpdateVersion;
    AppUploaderService appService;

    @DataBoundConstructor
    public AppUploaderBuilder(String uploadPath, Boolean isUpdateVersion, Integer appId) {
        this.uploadPath = uploadPath;
        this.isUpdateVersion = isUpdateVersion;
        this.appId = Boolean.TRUE.equals(isUpdateVersion) ? appId : null;
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public Integer getAppId() {
        return this.appId;
    }

    public Boolean getIsUpdateVersion() {
        return this.isUpdateVersion;
    }

    private PreSignedURL preSignS3URL(AppUploaderService appService, String fileName, Integer appId, Credential credential) throws IOException {
        return appService.generatePreSignedUploadURL(credential, fileName, appId);
    }

    private Boolean uploadFileToS3(AppUploaderService appService, String preSignedURL) throws IOException {
        return appService.uploadFileToS3(preSignedURL, this.uploadPath);
    }

    private Application createNewApplication(AppUploaderService appService, Credential credential, String fileName, String appPath) throws IOException {
        return appService.createApplication(credential, fileName, appPath);
    }

    private void injectEnvironmentVariables(Run<?, ?> run, String appId, Credential credential) {
        HashMap<String, String> envVariables = new HashMap<String, String>();
        envVariables.put("KOBITON_USERNAME", credential.getUsername());
        envVariables.put("KOBITON_API_KEY", credential.getApiKey());
        envVariables.put("KOBITON_APP_ID", appId);
        VariableInjectorAction variableInjectorAction = new VariableInjectorAction(envVariables);
        run.addAction((Action)variableInjectorAction);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        Credential credential = new Credential((String)env.get((Object)"USERNAME"), (String)env.get((Object)"API_KEY"));
        String fileName = this.uploadPath.substring(this.uploadPath.lastIndexOf("/") + 1);
        try {
            if (this.appService == null) {
                this.appService = new AppUploaderService();
            }
            PreSignedURL preSignedURL = this.preSignS3URL(this.appService, fileName, this.appId, credential);
            PluginLogger.debug("Pre-sign an URL successfully.", AppUploaderBuilder.class.getName());
            this.uploadFileToS3(this.appService, preSignedURL.url());
            PluginLogger.debug("Upload file to S3 successfully.", AppUploaderBuilder.class.getName());
            Application app = this.createNewApplication(this.appService, credential, fileName, preSignedURL.appPath());
            PluginLogger.log("Upload application to Apps Repository successfully. Application details: " + String.valueOf(app) + ".", logger);
            this.injectEnvironmentVariables(run, app.getAppOrVersionId(), credential);
        }
        catch (Exception e) {
            PluginLogger.error("Fail while process uploading app.", AppUploaderBuilder.class.getName(), logger);
            throw e;
        }
    }
}

