/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.junit.storage.database;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import io.jenkins.plugins.junit.storage.database.DatabaseTestResultStorage;

public class TestResultCleanupListener {

    @Extension
    public static class JobCleanupListener
    extends ItemListener {
        public void onDeleted(Item item) {
            DatabaseTestResultStorage storage;
            JunitTestResultStorage junitTestResultStorage = JunitTestResultStorage.find();
            if (junitTestResultStorage instanceof FileJunitTestResultStorage) {
                return;
            }
            if (junitTestResultStorage instanceof DatabaseTestResultStorage && (storage = (DatabaseTestResultStorage)junitTestResultStorage).isSkipCleanupRunsOnDeletion()) {
                return;
            }
            TestResultImpl testResult = junitTestResultStorage.load(item.getFullName(), 0);
            if (testResult instanceof DatabaseTestResultStorage.TestResultStorage) {
                DatabaseTestResultStorage.TestResultStorage storage2 = (DatabaseTestResultStorage.TestResultStorage)testResult;
                storage2.deleteJob();
            }
        }
    }

    @Extension
    public static class RunCleanupListener
    extends RunListener<Run> {
        public void onDeleted(Run run) {
            DatabaseTestResultStorage storage;
            JunitTestResultStorage junitTestResultStorage = JunitTestResultStorage.find();
            if (junitTestResultStorage instanceof FileJunitTestResultStorage) {
                return;
            }
            if (junitTestResultStorage instanceof DatabaseTestResultStorage && (storage = (DatabaseTestResultStorage)junitTestResultStorage).isSkipCleanupRunsOnDeletion()) {
                return;
            }
            TestResultImpl testResult = junitTestResultStorage.load(run.getParent().getFullName(), run.getNumber());
            if (testResult instanceof DatabaseTestResultStorage.TestResultStorage) {
                DatabaseTestResultStorage.TestResultStorage storage2 = (DatabaseTestResultStorage.TestResultStorage)testResult;
                storage2.deleteRun();
            }
        }
    }
}

