/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.junit.storage.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.HistoryTestResultSummary;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestDurationResultSummary;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.junit.TrendTestResultSummary;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorageDescriptor;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import io.jenkins.plugins.junit.storage.database.DatabaseSchemaLoader;
import io.jenkins.plugins.junit.storage.database.Messages;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class DatabaseTestResultStorage
extends JunitTestResultStorage {
    public static final Logger log = Logger.getLogger(DatabaseTestResultStorage.class.getName());
    static final int MAX_JOB_LENGTH = 255;
    static final int MAX_SUITE_LENGTH = 255;
    static final int MAX_PACKAGE_LENGTH = 255;
    static final int MAX_CLASSNAME_LENGTH = 255;
    static final int MAX_TEST_NAME_LENGTH = 500;
    static final int MAX_STDOUT_LENGTH = 100000;
    static final int MAX_STDERR_LENGTH = 100000;
    static final int MAX_STACK_TRACE_LENGTH = 100000;
    static final int MAX_ERROR_DETAILS_LENGTH = 100000;
    static final int MAX_SKIPPED_LENGTH = 1000;
    static final int MAX_DB_BATCH_SIZE = 2000;
    private static final Cache<String, List<CaseResult>> caseResultsCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(100L).removalListener((key, ignore, cause) -> log.config(String.format("Key '%s' removed from caseResultsCache because (%s)", key, cause))).build();
    private static final Cache<String, List<PackageResult>> packageResultsCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(100L).removalListener((key, ignore, cause) -> log.config(String.format("Key '%s' removed from packageResultsCache because (%s)", key, cause))).build();
    transient ConnectionSupplier connectionSupplier;
    private boolean skipCleanupRunsOnDeletion;

    @DataBoundConstructor
    public DatabaseTestResultStorage() {
    }

    public ConnectionSupplier getConnectionSupplier() {
        if (this.connectionSupplier == null) {
            log.config("getConnectionSupplier() -> initializing and returning a new LocalConnectionSupplier");
            this.connectionSupplier = new LocalConnectionSupplier();
        }
        log.fine("getConnectionSupplier() -> returning cached connectionSupplier");
        return this.connectionSupplier;
    }

    public boolean isSkipCleanupRunsOnDeletion() {
        return this.skipCleanupRunsOnDeletion;
    }

    @DataBoundSetter
    public void setSkipCleanupRunsOnDeletion(boolean skipCleanupRunsOnDeletion) {
        this.skipCleanupRunsOnDeletion = skipCleanupRunsOnDeletion;
    }

    public JunitTestResultStorage.RemotePublisher createRemotePublisher(Run<?, ?> build) throws IOException {
        try {
            log.config("createRemotePublisher() -> calling getConnectionSupplier().connection() for build " + build.getParent().getFullName() + " #" + build.getNumber());
            this.getConnectionSupplier().connection();
        }
        catch (SQLException x) {
            throw new IOException(x);
        }
        return new RemotePublisherImpl(build.getParent().getFullName(), build.getNumber());
    }

    public TestResultImpl load(String job, int build) {
        return new TestResultStorage(job, build);
    }

    private static Span createSpan(String spanName) {
        Span span = DatabaseTestResultStorage.getTracer().spanBuilder(spanName).startSpan();
        span.setAttribute("java.package", DatabaseTestResultStorage.class.getPackageName());
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withSpan(String spanName, Supplier<?> supplier) {
        Span span = DatabaseTestResultStorage.createSpan(spanName);
        try (Scope ignore = span.makeCurrent();){
            supplier.get();
        }
        finally {
            span.end();
        }
    }

    public static <T> T withSpan(String spanName, Function<Span, T> function) {
        Span span = DatabaseTestResultStorage.createSpan(spanName);
        try {
            T t;
            block9: {
                Scope ignore = span.makeCurrent();
                try {
                    t = function.apply(span);
                    if (ignore == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    private static void addSqlAttribute(Span span, String sql) {
        span.setAttribute("sql", sql);
    }

    private static void addPackageAttribute(Span span, String packageName) {
        span.setAttribute("package", packageName);
    }

    private static Tracer getTracer() {
        return GlobalOpenTelemetry.getTracer((String)"io.jenkins.plugins.junit.storage.database");
    }

    public static abstract class ConnectionSupplier
    implements AutoCloseable {
        private transient Connection connection;

        protected abstract Database database();

        protected void initialize(Connection connection) throws SQLException {
        }

        synchronized Connection connection() throws SQLException {
            if (this.connection == null || this.connection.isClosed()) {
                Connection _connection = this.database().getDataSource().getConnection();
                this.initialize(_connection);
                this.connection = _connection;
            }
            return this.connection;
        }

        @Override
        public void close() {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.connection = null;
        }
    }

    static class LocalConnectionSupplier
    extends ConnectionSupplier {
        LocalConnectionSupplier() {
        }

        @Override
        protected Database database() {
            return GlobalDatabaseConfiguration.get().getDatabase();
        }

        @Override
        protected void initialize(Connection connection) throws SQLException {
            DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.LocalConnectionSupplier.initialize", () -> {
                if (!DatabaseSchemaLoader.MIGRATED) {
                    DatabaseSchemaLoader.migrateSchema();
                }
                return null;
            });
        }
    }

    private static class RemotePublisherImpl
    implements JunitTestResultStorage.RemotePublisher {
        private final String job;
        private final int build;
        private final ConnectionSupplier connectionSupplier;

        RemotePublisherImpl(String job, int build) {
            this.job = job;
            this.build = build;
            this.connectionSupplier = new RemoteConnectionSupplier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(TestResult result, TaskListener listener) throws IOException {
            Span publishSpan = DatabaseTestResultStorage.createSpan("DatabaseTestResultStorage.RemotePublisherImpl.publish");
            String sql = "INSERT INTO caseResults (job, build, suite, package, className, testName, errorDetails, skipped, duration, stdout, stderr, stacktrace) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            try (Connection connection = this.connectionSupplier.connection();
                 PreparedStatement statement = connection.prepareStatement(sql);
                 Scope ignore = publishSpan.makeCurrent();){
                DatabaseTestResultStorage.addSqlAttribute(publishSpan, sql);
                int count = 0;
                for (SuiteResult suiteResult : result.getSuites()) {
                    for (CaseResult caseResult : suiteResult.getCases()) {
                        statement.setString(1, StringUtils.truncate((String)this.job, (int)255));
                        statement.setInt(2, this.build);
                        statement.setString(3, StringUtils.truncate((String)suiteResult.getName(), (int)255));
                        statement.setString(4, StringUtils.truncate((String)caseResult.getPackageName(), (int)255));
                        statement.setString(5, StringUtils.truncate((String)caseResult.getClassName(), (int)255));
                        statement.setString(6, StringUtils.truncate((String)caseResult.getName(), (int)500));
                        String errorDetails = caseResult.getErrorDetails();
                        if (errorDetails != null) {
                            errorDetails = StringUtils.truncate((String)errorDetails, (int)100000);
                            statement.setString(7, errorDetails);
                        } else {
                            statement.setNull(7, 12);
                        }
                        if (caseResult.isSkipped()) {
                            statement.setString(8, StringUtils.truncate((String)Util.fixNull((String)caseResult.getSkippedMessage()), (int)1000));
                        } else {
                            statement.setNull(8, 12);
                        }
                        statement.setFloat(9, caseResult.getDuration());
                        if (StringUtils.isNotEmpty((CharSequence)caseResult.getStdout())) {
                            statement.setString(10, StringUtils.truncate((String)caseResult.getStdout(), (int)100000));
                        } else {
                            statement.setNull(10, 12);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)caseResult.getStderr())) {
                            statement.setString(11, StringUtils.truncate((String)caseResult.getStderr(), (int)100000));
                        } else {
                            statement.setNull(11, 12);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)caseResult.getErrorStackTrace())) {
                            statement.setString(12, StringUtils.truncate((String)caseResult.getErrorStackTrace(), (int)100000));
                        } else {
                            statement.setNull(12, 12);
                        }
                        statement.addBatch();
                        if (++count % 2000 != 0) continue;
                        log.config(String.format("Inserting %d test cases for '%s #%d'.", 2000, this.job, this.build));
                        Span batchSpan = DatabaseTestResultStorage.getTracer().spanBuilder("sql batch insert caseResults").startSpan();
                        try {
                            Scope _ignore = batchSpan.makeCurrent();
                            try {
                                statement.executeBatch();
                                batchSpan.setAttribute("batchSize", 2000L);
                                statement.clearBatch();
                            }
                            finally {
                                if (_ignore == null) continue;
                                _ignore.close();
                            }
                        }
                        finally {
                            batchSpan.end();
                        }
                    }
                }
                if (count % 2000 != 0) {
                    Span batchSpan = DatabaseTestResultStorage.getTracer().spanBuilder("sql batch insert caseResults").startSpan();
                    try (Scope _ignore = batchSpan.makeCurrent();){
                        int[] updateCounts = statement.executeBatch();
                        int numberOfItemsStored = updateCounts.length;
                        log.config(String.format("Inserted final %d test cases for '%s #%d'.", numberOfItemsStored, this.job, this.build));
                        batchSpan.setAttribute("batchSize", (long)numberOfItemsStored);
                    }
                    finally {
                        batchSpan.end();
                    }
                }
                log.info(String.format("Saved %d test cases into database for '%s #%d'.", count, this.job, this.build));
            }
            catch (SQLException x) {
                throw new IOException(x);
            }
            finally {
                publishSpan.end();
            }
        }
    }

    public final class TestResultStorage
    implements TestResultImpl {
        private final String job;
        private final int build;

        public TestResultStorage(String job, int build) {
            this.job = job;
            this.build = build;
        }

        private <T> T query(Querier<T> querier) {
            try {
                Connection connection = DatabaseTestResultStorage.this.getConnectionSupplier().connection();
                return querier.run(connection);
            }
            catch (SQLException x) {
                throw new RuntimeException(x);
            }
        }

        List<CaseResult> getCaseResults() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getCaseResults", span -> {
                Run run;
                List caseResults;
                String cacheKey = this.getCacheKey();
                if (caseResultsCache.asMap().containsKey(cacheKey)) {
                    log.fine(String.format("Loading case results from cache for '%s'.", cacheKey));
                }
                if ((caseResults = (List)caseResultsCache.get((Object)cacheKey, key -> this.loadCaseResultsFromDB((Span)span))).isEmpty()) {
                    log.fine(String.format("Case results are empty for job %s so invalidating cache.", cacheKey));
                    caseResultsCache.invalidate((Object)cacheKey);
                }
                if ((run = this.getRun()) != null && run.isBuilding()) {
                    log.fine(String.format("Build '%s' is still running so invalidating case results cache.", cacheKey));
                    caseResultsCache.invalidate((Object)cacheKey);
                }
                return caseResults;
            });
        }

        private String getCacheKey() {
            return this.job + " #" + this.build;
        }

        private List<CaseResult> loadCaseResultsFromDB(Span parentSpan) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.loadCaseResultsFromDB", span -> this.query(connection -> {
                ArrayList<CaseResult> results = new ArrayList<CaseResult>();
                String sql = "SELECT suite, package, testname, classname, errordetails, skipped, duration, stdout, stderr, stacktrace FROM caseResults WHERE job = ? AND build = ?";
                DatabaseTestResultStorage.addSqlAttribute(span, sql);
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                    preparedStatement.setString(1, this.job);
                    preparedStatement.setInt(2, this.build);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        HashMap<String, ClassResult> classResults = new HashMap<String, ClassResult>();
                        TestResult parent = new TestResult((TestResultImpl)this);
                        while (resultSet.next()) {
                            String packageName = resultSet.getString("package");
                            String className = resultSet.getString("classname");
                            String testName = resultSet.getString("testname");
                            String errorDetails = resultSet.getString("errordetails");
                            String suite = resultSet.getString("suite");
                            String skipped = resultSet.getString("skipped");
                            String stdout = resultSet.getString("stdout");
                            String stderr = resultSet.getString("stderr");
                            String stacktrace = resultSet.getString("stacktrace");
                            float duration = resultSet.getFloat("duration");
                            SuiteResult suiteResult = new SuiteResult(suite, null, null, null);
                            suiteResult.setParent(parent);
                            CaseResult caseResult = new CaseResult(suiteResult, className, testName, errorDetails, skipped, duration, stdout, stderr, stacktrace);
                            ClassResult classResult = (ClassResult)classResults.get(className);
                            if (classResult == null) {
                                classResult = new ClassResult(new PackageResult(new TestResult((TestResultImpl)this), packageName), className);
                            }
                            classResult.add(caseResult);
                            caseResult.setClass(classResult);
                            classResults.put(className, classResult);
                            results.add(caseResult);
                        }
                        classResults.values().forEach(ClassResult::tally);
                    }
                }
                log.info(String.format("Loaded %d test cases from database for '%s #%d'.", results.size(), this.job, this.build));
                return results;
            }));
        }

        void deleteRun() {
            DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.deleteRun", span -> {
                log.info(String.format("Deleting test results and purging the cache for job %s #%d", this.job, this.build));
                String cacheKey = this.getCacheKey();
                caseResultsCache.invalidate((Object)cacheKey);
                packageResultsCache.invalidate((Object)cacheKey);
                return this.query(connection -> {
                    String sql = "DELETE FROM caseResults WHERE job = ? AND build = ?";
                    DatabaseTestResultStorage.addSqlAttribute(span, sql);
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        statement.setString(1, this.job);
                        span.setAttribute("job", this.job);
                        statement.setInt(2, this.build);
                        span.setAttribute("build", (long)this.build);
                        statement.execute();
                    }
                    return null;
                });
            });
        }

        private void invalidateCachesForJob(String jobName) {
            caseResultsCache.asMap().keySet().stream().filter(key -> key.startsWith(jobName)).forEach(arg_0 -> caseResultsCache.invalidate(arg_0));
            packageResultsCache.asMap().keySet().stream().filter(key -> key.startsWith(jobName)).forEach(arg_0 -> packageResultsCache.invalidate(arg_0));
        }

        void deleteJob() {
            DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.deleteJob", span -> {
                log.info(String.format("Deleting test results and purging the cache for job %s", this.job));
                this.invalidateCachesForJob(this.job);
                return this.query(connection -> {
                    String sql = "DELETE FROM caseResults WHERE job = ?";
                    DatabaseTestResultStorage.addSqlAttribute(span, sql);
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        statement.setString(1, this.job);
                        span.setAttribute("job", this.job);
                        statement.execute();
                    }
                    return null;
                });
            });
        }

        public List<PackageResult> getAllPackageResults() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getAllPackageResults", span -> {
                Run run;
                List packageResults;
                String cacheKey = this.getCacheKey();
                if (packageResultsCache.asMap().containsKey(cacheKey)) {
                    log.fine(String.format("Loading package results from cache for '%s'.", cacheKey));
                }
                if ((packageResults = (List)packageResultsCache.get((Object)cacheKey, k -> this.loadPackageResults())).isEmpty()) {
                    log.fine(String.format("Package results are empty for '%s' so invalidating cache.", cacheKey));
                    packageResultsCache.invalidate((Object)cacheKey);
                }
                if ((run = this.getRun()) != null && run.isBuilding()) {
                    log.fine(String.format("Build '%s' is still running so invalidating package results cache.", cacheKey));
                    packageResultsCache.invalidate((Object)cacheKey);
                }
                return packageResults;
            });
        }

        private List<PackageResult> loadPackageResults() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.loadPackageResults", span -> {
                TreeMap mapOfPackageResults = new TreeMap();
                TestResult testResult = new TestResult((TestResultImpl)this);
                this.getCaseResults().forEach(caseResult -> {
                    String packageName = caseResult.getPackageName();
                    PackageResult packageResult = mapOfPackageResults.computeIfAbsent(packageName, name -> new PackageResult(testResult, name));
                    packageResult.add(caseResult);
                });
                mapOfPackageResults.values().forEach(PackageResult::tally);
                log.info(String.format("Loaded %d package results from case results for '%s #%d'.", mapOfPackageResults.size(), this.job, this.build));
                span.setAttribute("numPackages", (long)mapOfPackageResults.size());
                return new ArrayList(mapOfPackageResults.values());
            });
        }

        public List<TrendTestResultSummary> getTrendTestResultSummary() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getTrendTestResultSummary", span -> this.query(connection -> {
                String sql = "SELECT build, sum(case when errorDetails is not null then 1 else 0 end) as failCount, sum(case when skipped is not null then 1 else 0 end) as skipCount, sum(case when errorDetails is null and skipped is null then 1 else 0 end) as passCount FROM caseResults WHERE job = ? group by build order by build;";
                DatabaseTestResultStorage.addSqlAttribute(span, sql);
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    ArrayList<TrendTestResultSummary> arrayList;
                    block13: {
                        statement.setString(1, this.job);
                        ResultSet result = statement.executeQuery();
                        try {
                            ArrayList<TrendTestResultSummary> trendTestResultSummaries = new ArrayList<TrendTestResultSummary>();
                            while (result.next()) {
                                int buildNumber = result.getInt("build");
                                int passed = result.getInt("passCount");
                                int failed = result.getInt("failCount");
                                int skipped = result.getInt("skipCount");
                                int total = passed + failed + skipped;
                                trendTestResultSummaries.add(new TrendTestResultSummary(buildNumber, new TestResultSummary(failed, skipped, passed, total)));
                            }
                            arrayList = trendTestResultSummaries;
                            if (result == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return arrayList;
                }
            }));
        }

        public List<TestDurationResultSummary> getTestDurationResultSummary() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getTestDurationResultSummary", span -> this.query(connection -> {
                String sql = "SELECT build, sum(duration) as duration FROM caseResults WHERE job = ? group by build order by build;";
                DatabaseTestResultStorage.addSqlAttribute(span, sql);
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    ArrayList<TestDurationResultSummary> arrayList;
                    block13: {
                        statement.setString(1, this.job);
                        ResultSet result = statement.executeQuery();
                        try {
                            ArrayList<TestDurationResultSummary> testDurationResultSummaries = new ArrayList<TestDurationResultSummary>();
                            while (result.next()) {
                                int buildNumber = result.getInt("build");
                                int duration = result.getInt("duration");
                                testDurationResultSummaries.add(new TestDurationResultSummary(buildNumber, (float)duration));
                            }
                            arrayList = testDurationResultSummaries;
                            if (result == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return arrayList;
                }
            }));
        }

        public List<HistoryTestResultSummary> getHistorySummary(int offset) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getHistorySummary", span -> {
                span.setAttribute("offset", (long)offset);
                return this.query(connection -> {
                    String sql = "SELECT build, sum(duration) as duration, sum(case when errorDetails is not null then 1 else 0 end) as failCount, sum(case when skipped is not null then 1 else 0 end) as skipCount, sum(case when errorDetails is null and skipped is null then 1 else 0 end) as passCount FROM caseResults WHERE job = ? GROUP BY build ORDER BY build DESC LIMIT 25 OFFSET ?;";
                    DatabaseTestResultStorage.addSqlAttribute(span, sql);
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        ArrayList<HistoryTestResultSummary> arrayList;
                        block13: {
                            statement.setString(1, this.job);
                            span.setAttribute("job", this.job);
                            statement.setInt(2, offset);
                            span.setAttribute("offset", (long)offset);
                            ResultSet result = statement.executeQuery();
                            try {
                                ArrayList<HistoryTestResultSummary> historyTestResultSummaries = new ArrayList<HistoryTestResultSummary>();
                                while (result.next()) {
                                    int buildNumber = result.getInt("build");
                                    int duration = result.getInt("duration");
                                    int passed = result.getInt("passCount");
                                    int failed = result.getInt("failCount");
                                    int skipped = result.getInt("skipCount");
                                    Job theJob = (Job)Jenkins.get().getItemByFullName(this.getJobName(), Job.class);
                                    if (theJob == null) continue;
                                    Run run = theJob.getBuildByNumber(buildNumber);
                                    historyTestResultSummaries.add(new HistoryTestResultSummary(run, (float)duration, failed, skipped, passed));
                                }
                                arrayList = historyTestResultSummaries;
                                if (result == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (result != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            result.close();
                        }
                        return arrayList;
                    }
                });
            });
        }

        public int getCountOfBuildsWithTestResults() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getCountOfBuildsWithTestResults", span -> this.query(connection -> {
                String sql = "SELECT COUNT(DISTINCT build) as count FROM caseResults WHERE job = ?;";
                DatabaseTestResultStorage.addSqlAttribute(span, sql);
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    Integer n;
                    block12: {
                        statement.setString(1, this.job);
                        span.setAttribute("job", this.job);
                        ResultSet result = statement.executeQuery();
                        try {
                            result.next();
                            n = result.getInt("count");
                            if (result == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return n;
                }
            }));
        }

        public PackageResult getPackageResult(String packageName) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getPackageResult", span -> {
                DatabaseTestResultStorage.addPackageAttribute(span, packageName);
                return this.getAllPackageResults().stream().filter(packageResult -> packageResult.getName().equals(packageName)).findFirst().orElse(null);
            });
        }

        public Run<?, ?> getFailedSinceRun(CaseResult caseResult) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getFailedSinceRun", span -> {
                span.setAttribute("build", (long)this.build);
                span.setAttribute("job", this.job);
                return this.query(connection -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                });
            });
        }

        private void addCaseResultToStatement(CaseResult caseResult, int build, PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.job);
            preparedStatement.setInt(2, build);
            preparedStatement.setString(3, caseResult.getSuiteResult().getName());
            preparedStatement.setString(4, caseResult.getPackageName());
            preparedStatement.setString(5, caseResult.getClassName());
            preparedStatement.setString(6, caseResult.getName());
        }

        public String getJobName() {
            return this.job;
        }

        public int getBuild() {
            return this.build;
        }

        public List<CaseResult> getFailedTestsByPackage(String packageName) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getFailedTestsByPackage", span -> {
                DatabaseTestResultStorage.addPackageAttribute(span, packageName);
                return this.getCaseResults().stream().filter(caseResult -> caseResult.getPackageName().equals(packageName)).filter(caseResult -> caseResult.getErrorDetails() != null).collect(Collectors.toList());
            });
        }

        public SuiteResult getSuite(String suiteName) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getSuite", span -> {
                span.setAttribute("suite", suiteName);
                log.fine(String.format("Getting suite result for suite %s from case results.", suiteName));
                SuiteResult suiteResult = new SuiteResult(suiteName, null, null, null);
                this.getCaseResults().stream().filter(caseResult -> caseResult.getSuiteResult().getName().equals(suiteName)).forEach(caseResult -> {
                    TestResult testResult = new TestResult((TestResultImpl)this);
                    String packageName = caseResult.getPackageName();
                    String className = caseResult.getClassName();
                    this.populateSuiteResult((CaseResult)caseResult, testResult, className, packageName, suiteResult);
                });
                return suiteResult;
            });
        }

        public Collection<SuiteResult> getSuites() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getSuites", span -> {
                log.fine("Getting suite results from case results.");
                TreeMap mapOfSuites = new TreeMap();
                this.getCaseResults().forEach(caseResult -> {
                    String suiteName = caseResult.getSuiteResult().getName();
                    SuiteResult suiteResult = mapOfSuites.computeIfAbsent(suiteName, name -> new SuiteResult(name, null, null, null));
                    TestResult testResult = new TestResult((TestResultImpl)this);
                    String packageName = caseResult.getPackageName();
                    String className = caseResult.getClassName();
                    this.populateSuiteResult((CaseResult)caseResult, testResult, className, packageName, suiteResult);
                    mapOfSuites.putIfAbsent(suiteName, suiteResult);
                });
                return mapOfSuites.values();
            });
        }

        private void populateSuiteResult(CaseResult caseResult, TestResult testResult, String className, String packageName, SuiteResult suiteResult) {
            PackageResult packageResult = new PackageResult(testResult, packageName);
            packageResult.add(caseResult);
            ClassResult classResult = new ClassResult(packageResult, className);
            classResult.add(caseResult);
            caseResult.setClass(classResult);
            suiteResult.addCase(caseResult);
        }

        public float getTotalTestDuration() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getTotalTestDuration", span -> this.getCaseResults().stream().map(CaseResult::getDuration).reduce(Float::sum).orElse(Float.valueOf(0.0f))).floatValue();
        }

        public int getFailCount() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getFailCount", span -> (int)this.getCaseResults().stream().filter(CaseResult::isFailed).count());
        }

        public int getSkipCount() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getSkipCount", span -> (int)this.getCaseResults().stream().filter(CaseResult::isSkipped).count());
        }

        public int getPassCount() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getPassCount", span -> (int)this.getCaseResults().stream().filter(CaseResult::isPassed).count());
        }

        public int getTotalCount() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getTotalCount", span -> this.getCaseResults().size());
        }

        public List<CaseResult> getFailedTests() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getFailedTests", span -> this.getCaseResults().stream().filter(caseResult -> caseResult.getErrorDetails() != null).collect(Collectors.toList()));
        }

        public List<CaseResult> getSkippedTests() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getSkippedTests", span -> this.getCaseResults().stream().filter(CaseResult::isSkipped).collect(Collectors.toList()));
        }

        public List<CaseResult> getSkippedTestsByPackage(String packageName) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getSkippedTestsByPackage", span -> {
                DatabaseTestResultStorage.addPackageAttribute(span, packageName);
                return this.getCaseResults().stream().filter(caseResult -> caseResult.getPackageName().equals(packageName)).filter(CaseResult::isSkipped).collect(Collectors.toList());
            });
        }

        public List<CaseResult> getPassedTests() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getPassedTests", span -> this.getCaseResults().stream().filter(caseResult -> !caseResult.isSkipped()).filter(caseResult -> caseResult.getErrorDetails() == null).collect(Collectors.toList()));
        }

        public List<CaseResult> getPassedTestsByPackage(String packageName) {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getPassedTestsByPackage", span -> {
                DatabaseTestResultStorage.addPackageAttribute(span, packageName);
                return this.getCaseResults().stream().filter(caseResult -> caseResult.getPackageName().equals(packageName)).filter(caseResult -> !caseResult.isSkipped()).filter(caseResult -> caseResult.getErrorDetails() == null).collect(Collectors.toList());
            });
        }

        @CheckForNull
        public TestResult getPreviousResult() {
            return DatabaseTestResultStorage.withSpan("DatabaseTestResultStorage.TestResultStorage.getPreviousResult", span -> {
                String sql = "SELECT build FROM caseResults WHERE job = ? AND build < ? ORDER BY build DESC LIMIT 1";
                DatabaseTestResultStorage.addSqlAttribute(span, sql);
                return this.query(connection -> {
                    try (PreparedStatement statement = connection.prepareStatement(sql);){
                        TestResult testResult;
                        block16: {
                            ResultSet result;
                            block14: {
                                TestResult testResult2;
                                block15: {
                                    statement.setString(1, this.job);
                                    statement.setInt(2, this.build);
                                    result = statement.executeQuery();
                                    try {
                                        if (!result.next()) break block14;
                                        int previousBuild = result.getInt("build");
                                        testResult2 = new TestResult(DatabaseTestResultStorage.this.load(this.job, previousBuild));
                                        if (result == null) break block15;
                                    }
                                    catch (Throwable throwable) {
                                        if (result != null) {
                                            try {
                                                result.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    result.close();
                                }
                                return testResult2;
                            }
                            testResult = null;
                            if (result == null) break block16;
                            result.close();
                        }
                        return testResult;
                    }
                });
            });
        }

        @NonNull
        public TestResult getResultByNodes(@NonNull List<String> nodeIds) {
            return new TestResult((TestResultImpl)this);
        }
    }

    static class RemoteConnectionSupplier
    extends ConnectionSupplier
    implements SerializableOnlyOverRemoting {
        private final Database database = GlobalDatabaseConfiguration.get().getDatabase();

        RemoteConnectionSupplier() {
        }

        @Override
        protected Database database() {
            return this.database;
        }
    }

    @FunctionalInterface
    private static interface Querier<T> {
        public T run(Connection var1) throws SQLException;
    }

    @Extension
    @Symbol(value={"database"})
    public static class DescriptorImpl
    extends JunitTestResultStorageDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.DatabaseTestResultStorage_displayName();
        }
    }
}

