/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.json_editor_parameter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

public final class JsonUtil {
    static String toJson(Map<String, Object> objectMap) {
        return JSONSerializer.toJSON(objectMap).toString();
    }

    static Map<String, Object> toMap(String json) {
        if (json == null) {
            return Map.of();
        }
        if ((json = json.trim()).isEmpty()) {
            return Map.of();
        }
        JSON jsonObject = JSONSerializer.toJSON((Object)json);
        if (jsonObject instanceof JSONObject) {
            return JsonUtil.toJavaUtilMap((JSONObject)jsonObject);
        }
        throw new IllegalArgumentException("Not a json object");
    }

    static Object toObject(String json) {
        if (json == null) {
            return null;
        }
        if ((json = json.trim()).isEmpty()) {
            return null;
        }
        return JsonUtil.toJavaUtil(JSONSerializer.toJSON((Object)json));
    }

    static Object toJavaUtil(Object object) {
        if (JsonUtil.isNull(object)) {
            return null;
        }
        if (object instanceof JSONArray) {
            return JsonUtil.toJavaUtilList((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return JsonUtil.toJavaUtilMap((JSONObject)object);
        }
        return object;
    }

    static List<Object> toJavaUtilList(JSONArray array) {
        return array.stream().map(JsonUtil::toJavaUtil).collect(Collectors.toList());
    }

    static Map<String, Object> toJavaUtilMap(JSONObject object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set entries = object.entrySet();
        entries.forEach(e -> result.put((String)e.getKey(), JsonUtil.toJavaUtil(e.getValue())));
        return result;
    }

    static boolean isNull(Object object) {
        if (object == null || object instanceof JSONNull) {
            return true;
        }
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            return jsonObject.isNullObject();
        }
        return false;
    }

    @Generated
    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

