/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.json_editor_parameter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.ParameterValue;
import hudson.model.Run;
import io.jenkins.plugins.json_editor_parameter.JsonUtil;
import java.util.Locale;
import lombok.Generated;
import org.kohsuke.stapler.DataBoundConstructor;

public class JsonEditorParameterValue
extends ParameterValue {
    private static final long serialVersionUID = 1L;
    private final String json;

    @DataBoundConstructor
    public JsonEditorParameterValue(@NonNull String name, @NonNull String value) {
        super(name);
        this.json = value;
    }

    public JsonEditorParameterValue(@NonNull String name, @NonNull String value, String description) {
        super(name, description);
        this.json = value;
    }

    public void buildEnvironment(@NonNull Run<?, ?> build, @NonNull EnvVars env) {
        if (this.json != null && !this.json.isEmpty()) {
            env.put(this.name, this.json);
            env.put(this.name.toUpperCase(Locale.ENGLISH), this.json);
        }
    }

    public Object getValue() {
        try {
            return JsonUtil.toObject(this.json);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    public String getJson() {
        return this.json;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonEditorParameterValue)) {
            return false;
        }
        JsonEditorParameterValue other = (JsonEditorParameterValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonEditorParameterValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }
}

