/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.json_editor_parameter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.FormValidation;
import io.jenkins.plugins.json_editor_parameter.DescriptorChecks;
import io.jenkins.plugins.json_editor_parameter.JsonEditorParameterValue;
import io.jenkins.plugins.json_editor_parameter.JsonUtil;
import java.util.HashMap;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import lombok.Generated;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class JsonEditorParameterDefinition
extends SimpleParameterDefinition {
    private static final Pattern OK_NAME = Pattern.compile("[A-Za-z][\\w-]{0,63}");
    private String schema;
    private String startval;
    private String options = "{}";

    @DataBoundConstructor
    public JsonEditorParameterDefinition(String name) {
        super(name);
        if (!JsonEditorParameterDefinition.isValidName(name)) {
            throw new IllegalArgumentException("Invalid Name - " + name);
        }
    }

    private static void checkValidJson(String json, String errorMessage) {
        try {
            JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static boolean isValidName(String name) {
        return OK_NAME.matcher(name).matches();
    }

    @DataBoundSetter
    public void setSchema(String schema) {
        JsonEditorParameterDefinition.checkValidJson(schema, "schema must be valid json");
        this.schema = schema;
    }

    @DataBoundSetter
    public void setStartval(String startval) {
        if ((startval = Util.fixEmptyAndTrim((String)startval)) != null) {
            JsonEditorParameterDefinition.checkValidJson(startval, "startval must be valid json or empty.");
        }
        this.startval = startval;
    }

    @DataBoundSetter
    public void setOptions(String options) {
        JsonEditorParameterDefinition.checkValidJson(options, "options must be valid json");
        this.options = options;
    }

    @Restricted(value={DoNotUse.class})
    public String getMergedOptions() {
        HashMap<String, Object> optionMap = new HashMap<String, Object>(JsonUtil.toMap(this.options));
        if (this.startval != null) {
            optionMap.put("startval", JsonUtil.toObject(this.startval));
        }
        optionMap.put("schema", JsonUtil.toMap(this.schema));
        return JsonUtil.toJson(optionMap);
    }

    public JsonEditorParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof JsonEditorParameterValue) {
            JsonEditorParameterDefinition def = new JsonEditorParameterDefinition(this.getName());
            def.setDescription(this.getDescription());
            def.setStartval(((JsonEditorParameterValue)defaultValue).getJson());
            return def;
        }
        return this;
    }

    public JsonEditorParameterValue createValue(StaplerRequest2 request, JSONObject jo) {
        JsonEditorParameterValue value = (JsonEditorParameterValue)((Object)request.bindJSON(JsonEditorParameterValue.class, jo));
        value.setDescription(this.getDescription());
        return value;
    }

    public JsonEditorParameterValue createValue(String json) {
        return new JsonEditorParameterValue(this.getName(), json, this.getDescription());
    }

    public JsonEditorParameterValue getDefaultParameterValue() {
        if (this.startval == null) {
            return null;
        }
        return new JsonEditorParameterValue(this.getName(), this.startval, this.getDescription());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonEditorParameterDefinition)) {
            return false;
        }
        JsonEditorParameterDefinition other = (JsonEditorParameterDefinition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$startval = this.getStartval();
        String other$startval = other.getStartval();
        if (this$startval == null ? other$startval != null : !this$startval.equals(other$startval)) {
            return false;
        }
        String this$options = this.getOptions();
        String other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonEditorParameterDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $startval = this.getStartval();
        result = result * 59 + ($startval == null ? 43 : $startval.hashCode());
        String $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public String getStartval() {
        return this.startval;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Extension
    @Symbol(value={"jsonEditor"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor
    implements DescriptorChecks {
        private static FormValidation isValidJson(String options, String errorMessage) {
            try {
                JsonEditorParameterDefinition.checkValidJson(options, errorMessage);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)errorMessage);
            }
        }

        @Override
        @POST
        public FormValidation doCheckName(@QueryParameter String name) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return JsonEditorParameterDefinition.isValidName(name) ? FormValidation.ok() : FormValidation.error((String)"Name should match regular expression [A-Za-z][\\w-]{0,63}");
        }

        @Override
        @POST
        public FormValidation doCheckOptions(@QueryParameter String options) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return DescriptorImpl.isValidJson(options, "options must be valid json");
        }

        @Override
        @POST
        public FormValidation doCheckSchema(@QueryParameter String schema) {
            Jenkins.get().checkPermission(Jenkins.READ);
            return DescriptorImpl.isValidJson(schema, "schema must be valid json");
        }

        @Override
        @POST
        public FormValidation doCheckStartval(@QueryParameter String startval) {
            Jenkins.get().checkPermission(Jenkins.READ);
            if (Util.fixEmptyAndTrim((String)startval) == null) {
                return FormValidation.ok();
            }
            return DescriptorImpl.isValidJson(startval, "startval must be valid json or empty");
        }

        @NonNull
        public String getDisplayName() {
            return "Json Editor Parameter Definition";
        }
    }
}

