/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.oras;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.jobcacher.oras.RegistryClient;
import io.jenkins.plugins.jobcacher.oras.RegistryItemPath;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import land.oras.ContainerRef;
import land.oras.exception.OrasException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

@Extension
public class RegistryItemStorage
extends ItemStorage<RegistryItemPath>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(RegistryItemStorage.class);
    private String storageCredentialId;
    private String registryUrl;
    private String namespace;

    @DataBoundConstructor
    public RegistryItemStorage() {
    }

    @DataBoundSetter
    public void setStorageCredentialId(String storageCredentialId) {
        this.storageCredentialId = storageCredentialId;
    }

    @DataBoundSetter
    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public RegistryItemPath getObjectPath(Item item, String path) {
        return new RegistryItemPath(this.createClient(), String.format("%s/%s", this.namespace, item.getFullName()), path);
    }

    public RegistryItemPath getObjectPathForBranch(Item item, String path, String branch) {
        String branchPath = new File(item.getFullName()).getParent() + "/" + branch;
        return new RegistryItemPath(this.createClient(), String.format("%s/%s", this.namespace, branchPath), path);
    }

    private RegistryClient createClient() {
        return new RegistryClient(this.registryUrl, this.namespace, (UsernamePasswordCredentials)RegistryItemStorage.getCredentials(this.storageCredentialId));
    }

    public static RegistryItemStorage get() {
        return (RegistryItemStorage)ExtensionList.lookupSingleton(RegistryItemStorage.class);
    }

    public static StandardUsernamePasswordCredentials getCredentials(String credentialsId) {
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
    }

    @Extension
    @Symbol(value={"oras"})
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<RegistryItemPath> {
        @NonNull
        public String getDisplayName() {
            return "oras";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item item) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(RegistryItemStorage.get().getStorageCredentialId());
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeCurrentValue(RegistryItemStorage.get().getStorageCredentialId());
        }

        public FormValidation doCheckRegistryUrl(@QueryParameter String registryUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.ok();
            if (registryUrl == null || registryUrl.isBlank()) {
                ret = FormValidation.error((String)"Server url cannot be blank");
            } else {
                try {
                    ContainerRef.parse((String)"%s/library/test:latest".formatted(registryUrl));
                }
                catch (OrasException e) {
                    ret = FormValidation.error((String)"Registry url doesn't seem valid.");
                }
            }
            return ret;
        }

        @RequirePOST
        public FormValidation doValidateRegistryConfig(@QueryParameter(value="registryUrl") String registryUrl, @QueryParameter(value="storageCredentialId") String storageCredentialId, @QueryParameter(value="namespace") String namespace) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (registryUrl == null || registryUrl.isBlank()) {
                return FormValidation.error((String)"Fields required");
            }
            if (namespace.endsWith("/")) {
                return FormValidation.error((String)"Namespace cannot end with /");
            }
            try {
                RegistryClient client = new RegistryClient(registryUrl, namespace, (UsernamePasswordCredentials)RegistryItemStorage.getCredentials(storageCredentialId));
                client.testConnection();
                LOGGER.debug("Registry configuration validated");
            }
            catch (Exception e) {
                LOGGER.error("Unable to connect to Registry. Please check the server url and credentials", (Throwable)e);
                return FormValidation.error((String)("Unable to connect to Registry. Please check the server url and credentials : " + e.getMessage()));
            }
            return FormValidation.ok((String)"Success");
        }
    }
}

