/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.oras;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Job;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.jobcacher.oras.RegistryClient;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.itemstorage.ObjectPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryItemPath
extends ObjectPath {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryItemPath.class);
    private final RegistryClient registry;
    private final String fullName;
    private final String path;

    public RegistryItemPath(RegistryClient registry, String fullName, String path) {
        this.registry = registry;
        this.fullName = fullName;
        this.path = path;
    }

    public RegistryClient getRegistry() {
        return this.registry;
    }

    public String getPath() {
        return this.path;
    }

    public RegistryItemPath child(String childPath) throws IOException, InterruptedException {
        return new RegistryItemPath(this.registry, this.fullName, String.format("%s/%s", this.path, childPath));
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        target.act((FilePath.FileCallable)new DownloadFromOciStorage(this.registry.getConfig(), this.fullName, this.path));
    }

    public void copyFrom(FilePath source) throws IOException, InterruptedException {
        source.act((FilePath.FileCallable)new UploadToOciStorage(this.registry.getConfig(), this.fullName, this.path));
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.registry.exists(this.fullName, this.path);
    }

    public void deleteRecursive() throws IOException, InterruptedException {
        this.registry.delete(this.fullName, this.path);
    }

    public HttpResponse browse(StaplerRequest2 request, StaplerResponse2 response, Job<?, ?> job, String name) {
        return null;
    }

    private static class DownloadFromOciStorage
    extends MasterToSlaveFileCallable<Void> {
        private static final Logger LOG = LoggerFactory.getLogger(DownloadFromOciStorage.class);
        private final RegistryClient.RegistryConfig config;
        private final String fullName;
        private final String path;

        public DownloadFromOciStorage(RegistryClient.RegistryConfig config, String fullName, String path) {
            this.config = config;
            this.fullName = fullName;
            this.path = path;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                new RegistryClient(this.config).download(this.fullName, this.path, f.toPath());
            }
            catch (Exception e) {
                throw new AbortException("Unable to upload cache to Registry. Details: " + e.getMessage());
            }
            return null;
        }
    }

    private static class UploadToOciStorage
    extends MasterToSlaveFileCallable<Void> {
        private final RegistryClient.RegistryConfig config;
        private final String path;
        private final String fullName;

        public UploadToOciStorage(RegistryClient.RegistryConfig config, String fullName, String path) {
            this.config = config;
            this.fullName = fullName;
            this.path = path;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                new RegistryClient(this.config).upload(this.fullName, this.path, f.toPath());
            }
            catch (Exception e) {
                throw new AbortException("Unable to upload cache to Registry. Details: " + e.getMessage());
            }
            return null;
        }
    }
}

