/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.oras;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import land.oras.Annotations;
import land.oras.ArtifactType;
import land.oras.Config;
import land.oras.ContainerRef;
import land.oras.Layer;
import land.oras.LocalPath;
import land.oras.Manifest;
import land.oras.Ref;
import land.oras.Registry;
import land.oras.exception.OrasException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryClient {
    public static final ArtifactType ARTIFACT_MEDIA_TYPE = ArtifactType.from((String)"application/vnd.jenkins.jobcacher.manifest.v1+json");
    public static final String CONFIG_MEDIA_TYPE = "application/vnd.jenkins.jobcacher.config.v1+json";
    public static final String CONTENT_MEDIA_TYPE = "application/vnd.jenkins.jobcacher.content.v1.%s";
    private static final Logger LOG = LoggerFactory.getLogger(RegistryClient.class);
    private final RegistryConfig config;
    private final Registry registry;

    public RegistryClient(@NonNull String registryUrl, @NonNull String namespace, @NonNull UsernamePasswordCredentials credentials) {
        this.config = new RegistryConfig(registryUrl, namespace, credentials);
        this.registry = this.buildRegistry();
    }

    public RegistryClient(@NonNull RegistryConfig config) {
        this(config.registryUrl(), config.namespace(), config.credentials());
    }

    public RegistryConfig getConfig() {
        return this.config;
    }

    public boolean exists(String fullName, String path) {
        ContainerRef ref = this.buildRef(fullName, path);
        try {
            boolean exists = this.registry.getTags(ref).tags().contains("latest");
            if (exists) {
                Manifest manifest = this.registry.getManifest(ref);
                LOG.debug("Artifact with full name {} and path {} exists in registry at digest {}", new Object[]{fullName, path, manifest.getDescriptor().getDigest()});
            }
            return exists;
        }
        catch (OrasException e) {
            LOG.debug("Artifact with full name {} and path {} doesn't exists: {}", new Object[]{fullName, path, e.getMessage()});
            return false;
        }
    }

    public void delete(String fullName, String path) {
        this.registry.deleteManifest(this.buildRef(fullName, path));
    }

    public void download(String fullName, String path, Path target) throws Exception {
        ContainerRef ref = this.buildRef(fullName, path);
        Manifest manifest = this.registry.getManifest(ref);
        try (InputStream is = this.registry.fetchBlob(ref.withDigest(((Layer)manifest.getLayers().get(0)).getDigest()));){
            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void upload(String fullName, String path, Path source) throws Exception {
        String extension;
        String compressionMediaType = switch (extension = path.substring(path.lastIndexOf(".")).replace(".", "")) {
            case "tar" -> "tar";
            case "zip" -> "zip";
            case "gz" -> "tar+gzip";
            case "zst" -> "tar+zstd";
            default -> "tar";
        };
        ContainerRef ref = this.buildRef(fullName, path);
        this.registry.pushArtifact(ref, ARTIFACT_MEDIA_TYPE, Annotations.ofManifest(Map.of("io.jenkins.jobcacher.fullname", fullName)), Config.empty().withMediaType(CONFIG_MEDIA_TYPE), new LocalPath[]{LocalPath.of((Path)source, (String)CONTENT_MEDIA_TYPE.formatted(compressionMediaType))});
    }

    private ContainerRef buildRef(String fullName, String path) {
        return ContainerRef.parse((String)"%s/%s:latest".formatted(fullName, path)).forRegistry(this.registry);
    }

    public void testConnection() throws Exception {
        Path tmpFile = Files.createTempFile("tmp-", "jenkins-oras-plugin-test", new FileAttribute[0]);
        Files.writeString(tmpFile, (CharSequence)"jenkins-oras-plugin-test", new OpenOption[0]);
        ContainerRef ref = ContainerRef.parse((String)"%s/jenkins-oras-plugin-test:latest".formatted(this.config.namespace())).forRegistry(this.config.registryUrl);
        Layer layer = this.registry.pushBlob((Ref)ref, tmpFile);
        this.registry.pushConfig((Ref)ref, Config.empty());
        Manifest manifest = this.registry.pushManifest(ref, Manifest.empty().withLayers(List.of(layer)));
        this.registry.deleteManifest(ref.withDigest(manifest.getDescriptor().getDigest()));
    }

    private Registry buildRegistry() {
        Registry.Builder builder = Registry.builder();
        if (this.config.credentials == null) {
            return builder.insecure().withRegistry(this.config.registryUrl).build();
        }
        return builder.defaults(this.config.credentials.getUsername(), this.config.credentials.getPassword().getPlainText()).withRegistry(this.config.registryUrl).build();
    }

    public record RegistryConfig(String registryUrl, String namespace, UsernamePasswordCredentials credentials) implements Serializable
    {
    }
}

