/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacherazurestorage;

import hudson.FilePath;
import hudson.model.Job;
import io.jenkins.plugins.jobcacherazurestorage.AzureClient;
import java.io.IOException;
import jenkins.plugins.itemstorage.ObjectPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class AzureObjectPath
extends ObjectPath {
    private final AzureClient azureClient;
    private final String fullName;
    private final String path;

    public AzureObjectPath(AzureClient azureClient, String fullName, String path) {
        this.azureClient = azureClient;
        this.fullName = fullName;
        this.path = path;
    }

    public ObjectPath child(String childPath) throws IOException, InterruptedException {
        return new AzureObjectPath(this.azureClient, this.fullName, this.path + "/" + childPath);
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        this.azureClient.download(target, this.fullName + "/" + this.path);
    }

    public void copyFrom(FilePath source) throws IOException, InterruptedException {
        this.azureClient.upload(source, this.fullName + "/" + this.path);
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.azureClient.exists(this.fullName + "/" + this.path);
    }

    public void deleteRecursive() {
        this.azureClient.delete(this.fullName + "/" + this.path);
    }

    public HttpResponse browse(StaplerRequest2 request, StaplerResponse2 response, Job<?, ?> job, String name) throws IOException {
        return null;
    }
}

