/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacherazurestorage;

import com.azure.core.credential.AzureSasCredential;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.google.common.io.Files;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;

public class AzureClient {
    private final BlobContainerClient container;
    private final String blobEndpoint;

    public AzureClient(BlobContainerClient container, String blobEndpoint) {
        this.container = container;
        this.blobEndpoint = blobEndpoint;
    }

    public boolean exists(String path) {
        return this.container.getBlobClient(path).exists();
    }

    public void download(FilePath target, String path) throws IOException, InterruptedException {
        BlobClient blobClient = this.container.getBlobClient(path);
        String sas = this.generateReadSas(blobClient);
        String blobUrl = blobClient.getBlobUrl() + "?" + sas;
        target.act((FilePath.FileCallable)new DownloadFromBlobStorage(Jenkins.get().proxy, this.blobEndpoint, blobUrl));
    }

    public void upload(FilePath filePath, String path) throws IOException, InterruptedException {
        BlobClient blobClient = this.container.getBlobClient(path);
        String sas = this.generateWriteSas(blobClient);
        String blobUrl = blobClient.getBlobUrl() + "?" + sas;
        filePath.act((FilePath.FileCallable)new UploadToBlobStorage(Jenkins.get().proxy, this.blobEndpoint, blobUrl));
    }

    private String generateReadSas(BlobClient blobClient) {
        BlobSasPermission permissions = new BlobSasPermission().setReadPermission(true);
        BlobServiceSasSignatureValues sasSignatureValues = new BlobServiceSasSignatureValues(AzureClient.generateExpiryDate(), permissions);
        return blobClient.generateSas(sasSignatureValues);
    }

    private String generateWriteSas(BlobClient blobClient) {
        BlobSasPermission permissions = new BlobSasPermission().setWritePermission(true);
        BlobServiceSasSignatureValues sasSignatureValues = new BlobServiceSasSignatureValues(AzureClient.generateExpiryDate(), permissions);
        return blobClient.generateSas(sasSignatureValues);
    }

    public static OffsetDateTime generateExpiryDate() {
        return OffsetDateTime.now().plusHours(1L);
    }

    public void delete(String filePath) {
        this.container.getBlobClient(filePath).delete();
    }

    private static class DownloadFromBlobStorage
    extends MasterToSlaveFileCallable<Void> {
        private final ProxyConfiguration proxy;
        private final String blobEndpoint;
        private final String blobUrl;

        public DownloadFromBlobStorage(ProxyConfiguration proxy, String blobEndpoint, String blobUrl) {
            this.proxy = proxy;
            this.blobEndpoint = blobEndpoint;
            this.blobUrl = blobUrl;
        }

        private BlobServiceClient getSynchronousBlobServiceClient(String sas) {
            return new BlobServiceClientBuilder().credential(new AzureSasCredential(sas)).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxy)).endpoint(this.blobEndpoint).buildClient();
        }

        private BlobClient getSynchronousBlobClient(BlobUrlParts blobUrlParts) {
            String sas = blobUrlParts.getCommonSasQueryParameters().encode();
            BlobServiceClient blobServiceClient = this.getSynchronousBlobServiceClient(sas);
            BlobContainerClient containerClient = blobServiceClient.getBlobContainerClient(blobUrlParts.getBlobContainerName());
            return containerClient.getBlobClient(blobUrlParts.getBlobName());
        }

        public Void invoke(File file, VirtualChannel channel) throws IOException {
            BlobUrlParts blobUrlParts = BlobUrlParts.parse((String)this.blobUrl);
            BlobClient blobClient = this.getSynchronousBlobClient(blobUrlParts);
            try (FileOutputStream fos = new FileOutputStream(file);){
                blobClient.downloadStream((OutputStream)fos);
            }
            return null;
        }
    }

    private static class UploadToBlobStorage
    extends MasterToSlaveFileCallable<Void> {
        public static final int TIMEOUT = 30;
        private final ProxyConfiguration proxy;
        private final String blobEndpoint;
        private final String blobUrl;

        UploadToBlobStorage(ProxyConfiguration proxy, String blobEndpoint, String blobUrl) {
            this.proxy = proxy;
            this.blobEndpoint = blobEndpoint;
            this.blobUrl = blobUrl;
        }

        private BlobServiceClient getSynchronousBlobServiceClient(String sas) {
            return new BlobServiceClientBuilder().credential(new AzureSasCredential(sas)).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxy)).endpoint(this.blobEndpoint).buildClient();
        }

        public Void invoke(File file, VirtualChannel channel) {
            BlobUrlParts blobUrlParts = BlobUrlParts.parse((String)this.blobUrl);
            BlobClient blobClient = this.getSynchronousBlobClient(blobUrlParts);
            BlobUploadFromFileOptions options = new BlobUploadFromFileOptions(file.getAbsolutePath()).setHeaders(this.getBlobHttpHeaders(file));
            blobClient.uploadFromFileWithResponse(options, Duration.ofSeconds(30L), null);
            return null;
        }

        private BlobClient getSynchronousBlobClient(BlobUrlParts blobUrlParts) {
            String sas = blobUrlParts.getCommonSasQueryParameters().encode();
            BlobServiceClient blobServiceClient = this.getSynchronousBlobServiceClient(sas);
            BlobContainerClient containerClient = blobServiceClient.getBlobContainerClient(blobUrlParts.getBlobContainerName());
            return containerClient.getBlobClient(blobUrlParts.getBlobName());
        }

        private BlobHttpHeaders getBlobHttpHeaders(File file) {
            BlobHttpHeaders method = new BlobHttpHeaders();
            UploadToBlobStorage.contentType(file).ifPresent(arg_0 -> ((BlobHttpHeaders)method).setContentType(arg_0));
            return method;
        }

        private static Optional<String> contentType(File file) {
            String fileExtension;
            return Optional.ofNullable(switch (fileExtension = Files.getFileExtension((String)file.getName())) {
                case "zip" -> "application/zip";
                case "tgz" -> "application/gzip";
                case "tar" -> "application/x-tar";
                case "zst" -> "application/zstd";
                default -> null;
            });
        }
    }
}

