/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacherazurestorage;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import io.jenkins.plugins.jobcacherazurestorage.AzureClient;
import io.jenkins.plugins.jobcacherazurestorage.AzureObjectPath;
import io.jenkins.plugins.jobcacherazurestorage.Messages;
import java.io.File;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Extension
public class AzureItemStorage
extends ItemStorage<AzureObjectPath> {
    private String credentialsId;
    private String containerName;

    @DataBoundConstructor
    public AzureItemStorage() {
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public AzureObjectPath getObjectPath(Item item, String path) {
        AzureClient azureClient = this.getAzureClient(item);
        return new AzureObjectPath(azureClient, item.getFullName(), path);
    }

    private AzureClient getAzureClient(Item item) {
        AzureStorageAccount.StorageAccountCredential accountCredential = AzureStorageAccount.getStorageAccountCredential((Item)item, (String)this.credentialsId);
        BlobServiceClient blobServiceClient = AzureItemStorage.getBlobServiceClient(accountCredential);
        BlobContainerClient blobContainerClient = blobServiceClient.getBlobContainerClient(this.containerName);
        return new AzureClient(blobContainerClient, blobServiceClient.getAccountUrl());
    }

    private static BlobServiceClient getBlobServiceClient(AzureStorageAccount.StorageAccountCredential accountCredential) {
        return new BlobServiceClientBuilder().credential(new StorageSharedKeyCredential(accountCredential.getStorageAccountName(), accountCredential.getStorageAccountKey())).httpClient(HttpClientRetriever.get()).endpoint(accountCredential.getBlobEndpointURL()).buildClient();
    }

    public AzureObjectPath getObjectPathForBranch(Item item, String path, String branch) {
        String branchPath = new File(item.getFullName()).getParent() + "/" + branch;
        AzureClient azureClient = this.getAzureClient(item);
        return new AzureObjectPath(azureClient, branchPath, path);
    }

    public static AzureItemStorage get() {
        return (AzureItemStorage)((Object)ExtensionList.lookupSingleton(AzureItemStorage.class));
    }

    @Extension
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<AzureObjectPath> {
        @NonNull
        public String getDisplayName() {
            return Messages.AzureItemStorage_displayName();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String value) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(AzureItemStorage.get().getCredentialsId());
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, AzureStorageAccount.class, Collections.emptyList(), CredentialsMatchers.instanceOf(AzureStorageAccount.class)).includeCurrentValue(AzureItemStorage.get().getCredentialsId());
        }
    }
}

