/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.artifactory;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.jobcacher.artifactory.ArtifactoryClient;
import io.jenkins.plugins.jobcacher.artifactory.ArtifactoryItemPath;
import io.jenkins.plugins.jobcacher.artifactory.Utils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ItemStorage;
import jenkins.plugins.itemstorage.ItemStorageDescriptor;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ArtifactoryItemStorage
extends ItemStorage<ArtifactoryItemPath>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SERVER_URL_REGEXP = "^(http://|https://)[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?(/[0-9a-zA-Z_]*)*$";
    private static final Pattern endPointPattern = Pattern.compile("^(http://|https://)[a-z0-9][a-z0-9-.]{0,}(?::[0-9]{1,5})?(/[0-9a-zA-Z_]*)*$", 2);
    public static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryItemStorage.class);
    private String storageCredentialId;
    private String serverUrl;
    private String repository;
    private String prefix;

    @DataBoundConstructor
    public ArtifactoryItemStorage() {
    }

    @DataBoundSetter
    public void setStorageCredentialId(String storageCredentialId) {
        this.storageCredentialId = storageCredentialId;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @DataBoundSetter
    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ArtifactoryItemPath getObjectPath(Item item, String path) {
        return new ArtifactoryItemPath(this.createArtifactoryClient(), String.format("%s/%s", this.prefix, item.getFullName()), path);
    }

    public ArtifactoryItemPath getObjectPathForBranch(Item item, String path, String branch) {
        String branchPath = new File(item.getFullName()).getParent() + "/" + branch;
        return new ArtifactoryItemPath(this.createArtifactoryClient(), String.format("%s/%s", this.prefix, branchPath), path);
    }

    public void deletePath(String path) {
        try (ArtifactoryClient client = this.createArtifactoryClient();){
            if (client.isFolder(String.format("%s/%s", this.prefix, path))) {
                client.deleteArtifact(String.format("%s/%s", this.prefix, path));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to delete path at %s", path), (Throwable)e);
        }
    }

    public void movePath(String fromPath, String toPath) {
        try (ArtifactoryClient client = this.createArtifactoryClient();){
            if (client.isFolder(String.format("%s/%s", this.prefix, fromPath))) {
                client.move(String.format("%s/%s", this.prefix, fromPath), String.format("%s/%s", this.prefix, toPath));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to move path from %s to %s", fromPath, toPath), (Throwable)e);
        }
    }

    private ArtifactoryClient createArtifactoryClient() {
        return new ArtifactoryClient(this.serverUrl, this.repository, (UsernamePasswordCredentials)Utils.getCredentials(this.storageCredentialId));
    }

    public static ArtifactoryItemStorage get() {
        return (ArtifactoryItemStorage)ExtensionList.lookupSingleton(ArtifactoryItemStorage.class);
    }

    @Extension
    public static final class ArtifactoryItemListener
    extends ItemListener {
        public void onDeleted(Item item) {
            ArtifactoryItemStorage artifactoryItemStorage = this.lookupArtifactoryStorage();
            if (artifactoryItemStorage == null) {
                return;
            }
            artifactoryItemStorage.deletePath(item.getFullName());
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            ArtifactoryItemStorage artifactoryItemStorage = this.lookupArtifactoryStorage();
            if (artifactoryItemStorage == null) {
                return;
            }
            artifactoryItemStorage.movePath(oldFullName, newFullName);
        }

        private ArtifactoryItemStorage lookupArtifactoryStorage() {
            ItemStorage storage = GlobalItemStorage.get().getStorage();
            if (storage instanceof ArtifactoryItemStorage) {
                return (ArtifactoryItemStorage)storage;
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ItemStorageDescriptor<ArtifactoryItemPath> {
        public String getDisplayName() {
            return "Artifactory";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item item) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(ArtifactoryItemStorage.get().getStorageCredentialId());
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeCurrentValue(ArtifactoryItemStorage.get().getStorageCredentialId());
        }

        public FormValidation doCheckRepository(@QueryParameter String repository) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.ok();
            if (repository == null || repository.isBlank()) {
                ret = FormValidation.error((String)"Repository cannot be blank");
            }
            return ret;
        }

        public FormValidation doCheckServerUrl(@QueryParameter String serverUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.ok();
            if (serverUrl == null || serverUrl.isBlank()) {
                ret = FormValidation.error((String)"Server url cannot be blank");
            } else if (!endPointPattern.matcher(serverUrl).matches()) {
                ret = FormValidation.error((String)"Server url doesn't seem valid. Should start with http:// or https://");
            }
            return ret;
        }

        @RequirePOST
        public FormValidation doValidateArtifactoryConfig(@QueryParameter(value="serverUrl") String serverUrl, @QueryParameter(value="storageCredentialId") String storageCredentialId, @QueryParameter(value="repository") String repository, @QueryParameter(value="prefix") String prefix) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (serverUrl == null || storageCredentialId == null || repository == null || serverUrl.isBlank() || storageCredentialId.isBlank() || repository.isBlank()) {
                return FormValidation.error((String)"Fields required");
            }
            try {
                Path tmpFile = Files.createTempFile("tmp-", "jenkins-artifactory-plugin-test", new FileAttribute[0]);
                try (ArtifactoryClient client = new ArtifactoryClient(serverUrl, repository, (UsernamePasswordCredentials)Utils.getCredentials(storageCredentialId));){
                    client.uploadArtifact(tmpFile, String.format("%s/%s", prefix, tmpFile.getFileName()));
                    client.deleteArtifact(String.format("%s/%s", prefix, tmpFile.getFileName()));
                }
                LOGGER.debug("Artifactory configuration validated");
            }
            catch (Exception e) {
                LOGGER.error("Unable to connect to Artifactory. Please check the server url and credentials", (Throwable)e);
                return FormValidation.error((String)("Unable to connect to Artifactory. Please check the server url and credentials : " + e.getMessage()));
            }
            return FormValidation.ok((String)"Success");
        }
    }
}

