/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.artifactory;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Job;
import hudson.remoting.VirtualChannel;
import hudson.util.IOUtils;
import io.jenkins.plugins.jobcacher.artifactory.ArtifactoryClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.itemstorage.ObjectPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class ArtifactoryItemPath
extends ObjectPath {
    private final ArtifactoryClient client;
    private final String fullName;
    private final String path;

    public ArtifactoryItemPath(ArtifactoryClient client, String fullName, String path) {
        this.client = client;
        this.fullName = fullName;
        this.path = path;
    }

    public ArtifactoryClient getClient() {
        return this.client;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPath() {
        return this.path;
    }

    public ArtifactoryItemPath child(String childPath) throws IOException, InterruptedException {
        return new ArtifactoryItemPath(this.client, this.fullName, String.format("%s/%s", this.path, childPath));
    }

    public void copyTo(FilePath target) throws IOException, InterruptedException {
        target.act((FilePath.FileCallable)new DownloadFromArtifactoryStorage(this.client.getConfig(), String.format("%s/%s", this.fullName, this.path)));
    }

    public void copyFrom(FilePath source) throws IOException, InterruptedException {
        source.act((FilePath.FileCallable)new UploadToArtifactoryStorage(this.client.getConfig(), String.format("%s/%s", this.fullName, this.path)));
    }

    public boolean exists() throws IOException, InterruptedException {
        return this.client.isFile(String.format("%s/%s", this.fullName, this.path));
    }

    public void deleteRecursive() throws IOException, InterruptedException {
        this.client.deleteArtifact(String.format("%s/%s", this.fullName, this.path));
    }

    public HttpResponse browse(StaplerRequest2 request, StaplerResponse2 response, Job<?, ?> job, String name) throws IOException {
        return null;
    }

    private static class DownloadFromArtifactoryStorage
    extends MasterToSlaveFileCallable<Void> {
        private final ArtifactoryClient.ArtifactoryConfig config;
        private final String path;

        public DownloadFromArtifactoryStorage(ArtifactoryClient.ArtifactoryConfig config, String path) {
            this.config = config;
            this.path = path;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try (ArtifactoryClient client = new ArtifactoryClient(this.config);
                 InputStream is = client.downloadArtifact(this.path);){
                IOUtils.copy((InputStream)is, (File)f);
            }
            catch (Exception e) {
                throw new AbortException("Unable to upload cache to Artifactory. Details: " + e.getMessage());
            }
            return null;
        }
    }

    private static class UploadToArtifactoryStorage
    extends MasterToSlaveFileCallable<Void> {
        private final ArtifactoryClient.ArtifactoryConfig config;
        private final String path;

        public UploadToArtifactoryStorage(ArtifactoryClient.ArtifactoryConfig config, String path) {
            this.config = config;
            this.path = path;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try (ArtifactoryClient client = new ArtifactoryClient(this.config);){
                client.uploadArtifact(f.toPath(), this.path);
            }
            catch (Exception e) {
                throw new AbortException("Unable to upload cache to Artifactory. Details: " + e.getMessage());
            }
            return null;
        }
    }
}

