/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobcacher.artifactory;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.ArtifactoryClientBuilder;
import org.jfrog.artifactory.client.DownloadableArtifact;
import org.jfrog.artifactory.client.ItemHandle;
import org.jfrog.artifactory.client.UploadableArtifact;
import org.jfrog.artifactory.client.model.File;
import org.jfrog.filespecs.FileSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactoryClient
implements AutoCloseable {
    public static final Logger LOGGER = LoggerFactory.getLogger(ArtifactoryClient.class);
    private final ArtifactoryConfig config;
    private final Artifactory artifactory;

    public ArtifactoryClient(@NonNull String serverUrl, @NonNull String repository, @NonNull UsernamePasswordCredentials credentials) {
        this.config = new ArtifactoryConfig(serverUrl, repository, credentials);
        this.artifactory = this.buildArtifactory();
    }

    public ArtifactoryClient(@NonNull ArtifactoryConfig config) {
        this(config.getServerUrl(), config.getRepository(), config.getCredentials());
    }

    public ArtifactoryConfig getConfig() {
        return this.config;
    }

    public void uploadArtifact(Path file, String targetPath) throws IOException {
        UploadableArtifact artifact = this.artifactory.repository(this.config.repository).upload(this.urlEncodeParts(targetPath), file.toFile());
        artifact.withSize(Files.size(file));
        artifact.withListener((bytesRead, totalBytes) -> LOGGER.trace(String.format("Uploaded %d/%d", bytesRead, totalBytes)));
        artifact.doUpload();
        LOGGER.trace(String.format("Uploaded %s to %s", file, targetPath));
    }

    public void deleteArtifact(String targetPath) {
        this.artifactory.repository(this.config.repository).delete(this.urlEncodeParts(targetPath));
    }

    public void move(String sourcePath, String targetPath) {
        ItemHandle sourceItem = this.artifactory.repository(this.config.repository).folder(this.urlEncodeParts(sourcePath));
        sourceItem.move(this.config.repository, this.urlEncodeParts(targetPath));
    }

    public void copy(String sourcePath, String targetPath) {
        ItemHandle sourceItem = this.artifactory.repository(this.config.repository).folder(this.urlEncodeParts(sourcePath));
        sourceItem.copy(this.config.repository, targetPath);
    }

    public InputStream downloadArtifact(String targetPath) throws IOException {
        DownloadableArtifact artifact = this.artifactory.repository(this.config.repository).download(this.urlEncodeParts(targetPath));
        return artifact.doDownload();
    }

    public boolean isFolder(String targetPath) throws IOException {
        try {
            return this.artifactory.repository(this.config.repository).isFolder(this.urlEncodeParts(targetPath));
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to check if %s is a folder", targetPath));
            return false;
        }
    }

    public List<String> list(String targetPath) throws IOException {
        if (!this.isFolder(targetPath)) {
            LOGGER.debug(String.format("Target path %s is not a folder. Cannot list files", targetPath));
            return List.of();
        }
        FileSpec fileSpec = FileSpec.fromString((String)String.format("{\"files\": [{\"pattern\": \"%s/%s*\"}]}", this.config.repository, targetPath));
        return this.artifactory.searches().artifactsByFileSpec(fileSpec).stream().map(item -> String.format("%s/%s", item.getPath(), item.getName())).collect(Collectors.toList());
    }

    public boolean isFile(String targetPath) throws IOException {
        if (this.isFolder(targetPath)) {
            return false;
        }
        try {
            File file = (File)this.artifactory.repository(this.config.repository).file(this.urlEncodeParts(targetPath)).info();
            return !file.isFolder();
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to check if %s is a file", targetPath));
            return false;
        }
    }

    public long lastUpdated(String targetPath) throws IOException {
        LOGGER.trace(String.format("Getting last updated time for %s", targetPath));
        return this.artifactory.repository(this.config.repository).file(targetPath).info().getLastModified().getTime();
    }

    public long size(String targetPath) throws IOException {
        if (this.isFolder(targetPath)) {
            return 0L;
        }
        LOGGER.trace(String.format("Getting size for %s", targetPath));
        File file = (File)this.artifactory.repository(this.config.repository).file(this.urlEncodeParts(targetPath)).info();
        return file.getSize();
    }

    public ArtifactoryConfig buildArtifactoryConfig() {
        return new ArtifactoryConfig(this.config.serverUrl, this.config.repository, this.config.credentials);
    }

    private Artifactory buildArtifactory() {
        return ArtifactoryClientBuilder.create().setUrl(this.config.serverUrl).setUsername(this.config.credentials.getUsername()).setPassword(this.config.credentials.getPassword().getPlainText()).addInterceptorLast((request, httpContext) -> LOGGER.debug(String.format("Sending Artifactory request to %s", request.getRequestLine()))).build();
    }

    private String urlEncodeParts(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("%2F", "/").replace("+", "%20");
    }

    @Override
    public void close() throws Exception {
        this.artifactory.close();
    }

    public static final class ArtifactoryConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String serverUrl;
        private final String repository;
        private final UsernamePasswordCredentials credentials;

        public ArtifactoryConfig(String serverUrl, String repository, UsernamePasswordCredentials credentials) {
            this.serverUrl = serverUrl;
            this.repository = repository;
            this.credentials = credentials;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getRepository() {
            return this.repository;
        }

        public UsernamePasswordCredentials getCredentials() {
            return this.credentials;
        }
    }
}

