/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.inodesnodemonitor;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.inodesnodemonitor.DfRunner;
import org.jenkinsci.plugins.inodesnodemonitor.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

public class InodesMonitor
extends NodeMonitor {
    private static final Logger LOGGER = Logger.getLogger(InodesMonitor.class.getSimpleName());
    private static final String DEFAULT_OFFLINE_THRESHOLD = "95%";
    public final String inodesPercentThreshold;
    @Extension
    public static final InodesUseInPercentMonitorDescriptor DESCRIPTOR = new InodesUseInPercentMonitorDescriptor();

    @DataBoundConstructor
    public InodesMonitor(String inodesPercentThreshold) throws ParseException {
        if (inodesPercentThreshold == null) {
            inodesPercentThreshold = DEFAULT_OFFLINE_THRESHOLD;
        }
        InodesMonitor.parse(inodesPercentThreshold);
        this.inodesPercentThreshold = inodesPercentThreshold;
    }

    public InodesMonitor() {
        this.inodesPercentThreshold = DEFAULT_OFFLINE_THRESHOLD;
    }

    @VisibleForTesting
    static int parse(String threshold) throws ParseException {
        if (!threshold.matches("\\d?\\d%")) {
            throw new ParseException(threshold, 0);
        }
        return Integer.parseInt(threshold.substring(0, threshold.length() - 1));
    }

    public Object data(Computer computer) {
        String currentValueStr = (String)super.data(computer);
        Inodes inodes = new Inodes(currentValueStr, this.inodesPercentThreshold);
        if (currentValueStr == null || currentValueStr.contains(Messages.inodesmonitor_notapplicable())) {
            return inodes;
        }
        try {
            int currentValue = InodesMonitor.parse(currentValueStr);
            String currentState = "current=" + currentValue + ",threshold=" + this.inodesPercentThreshold;
            String computerName = computer.getName();
            if (computer.getName().isEmpty()) {
                computerName = "built-in";
            }
            if (currentValue >= InodesMonitor.parse(this.inodesPercentThreshold)) {
                inodes.setTriggered(((Object)((Object)this)).getClass(), true);
                if (((InodesUseInPercentMonitorDescriptor)this.getDescriptor()).markOffline(computer, (OfflineCause)inodes)) {
                    String inodesmonitor_markedOffline = Messages.inodesmonitor_markedOffline(computerName, currentState);
                    LOGGER.warning(inodesmonitor_markedOffline);
                }
            } else if (computer.getOfflineCause() instanceof Inodes && ((InodesUseInPercentMonitorDescriptor)this.getDescriptor()).markOnline(computer)) {
                LOGGER.info(Messages.inodesmonitor_markedOnline(computerName, currentState));
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("WTF? Can't parse " + currentValueStr + " as integer percentage", e);
        }
        return inodes;
    }

    public final String getColumnCaption() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? super.getColumnCaption() : null;
    }

    @ExportedBean
    public static final class Inodes
    extends MonitorOfflineCause
    implements Serializable {
        private Class<? extends NodeMonitor> trigger;
        private final String usage;
        private final String threshold;
        private boolean triggered;

        public Inodes(String usage, String threshold) {
            this.usage = usage;
            this.threshold = threshold;
        }

        void setTriggered(Class<? extends NodeMonitor> trigger, boolean triggered) {
            this.trigger = trigger;
            this.triggered = triggered;
        }

        public boolean isTriggered() {
            return this.triggered;
        }

        @NonNull
        public Class<? extends NodeMonitor> getTrigger() {
            return this.trigger;
        }

        public String getUsage() {
            return this.usage;
        }

        public String toString() {
            return Messages.inodesmonitor_FreeInodesTooLow(this.usage, this.threshold);
        }
    }

    static class InodesUseInPercentMonitorDescriptor
    extends AbstractAsyncNodeMonitorDescriptor<String> {
        InodesUseInPercentMonitorDescriptor() {
        }

        @NonNull
        public String getDisplayName() {
            return Messages.inodesmonitor_useinpercent();
        }

        protected Callable<String, IOException> createCallable(Computer c) {
            return new GetInodesUseInPercent();
        }

        public boolean markOffline(Computer c, OfflineCause oc) {
            return super.markOffline(c, oc);
        }

        public boolean markOnline(Computer c) {
            return super.markOnline(c);
        }
    }

    private static class GetInodesUseInPercent
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetInodesUseInPercent() {
        }

        public String call() {
            return new DfRunner().getUsedInodesPercentage();
        }
    }
}

