/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.inodesnodemonitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.inodesnodemonitor.Messages;

class DfRunner {
    private static final Logger LOGGER = Logger.getLogger(DfRunner.class.getSimpleName());
    private static Map<String, DfCommand> IMPLEMENTATIONS = new LinkedHashMap<String, DfCommand>();

    DfRunner() {
    }

    public String getUsedInodesPercentage() {
        return this.findImplementation().get();
    }

    private DfCommand findImplementation() {
        String osName = System.getProperty("os.name");
        for (Map.Entry<String, DfCommand> impl : IMPLEMENTATIONS.entrySet()) {
            String key = impl.getKey();
            if (!osName.toLowerCase().startsWith(key)) continue;
            LOGGER.fine(() -> "DfRunner implementation key selected: " + key);
            return impl.getValue();
        }
        return new DefaultDfCommand();
    }

    static {
        IMPLEMENTATIONS.put("windows", new WindowsDfCommand());
        IMPLEMENTATIONS.put("linux", new LinuxDfCommand());
        IMPLEMENTATIONS.put("mac os", new MacOsDfCommand());
        IMPLEMENTATIONS.put("freebsd", new MacOsDfCommand());
        IMPLEMENTATIONS.put("aix", new AixDfCommand());
    }

    private static abstract class DfCommand {
        private String command;
        public final int line;
        public final int column;

        DfCommand(String command, int line, int column) {
            this.command = command;
            this.line = line;
            this.column = column;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String get() {
            try {
                LOGGER.finer(() -> "Inodes monitoring: running '" + this.command + "' command in " + System.getProperty("user.dir"));
                Process process = Runtime.getRuntime().exec(this.command);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.US_ASCII));){
                    for (int i = 1; i < this.line; ++i) {
                        bufferedReader.readLine();
                    }
                    String values = bufferedReader.readLine();
                    if (values == null) {
                        String string = Messages.inodesmonitor_notapplicable_onerror();
                        return string;
                    }
                    LOGGER.fine(() -> "df values output: " + values);
                    String[] split = values.split(" +");
                    String string = split[this.column - 1];
                    return string;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Error while running '" + this.command + "'");
                return Messages.inodesmonitor_notapplicable_onerror();
            }
        }
    }

    private static class DefaultDfCommand
    extends DfCommand {
        DefaultDfCommand() {
            super("df -i .", 2, 5);
        }
    }

    private static class WindowsDfCommand
    extends DfCommand {
        WindowsDfCommand() {
            super(null, -1, -1);
        }

        @Override
        public String get() {
            return Messages.inodesmonitor_notapplicable();
        }
    }

    private static class LinuxDfCommand
    extends DfCommand {
        LinuxDfCommand() {
            super("df -P -i .", 2, 5);
        }
    }

    private static class MacOsDfCommand
    extends DfCommand {
        MacOsDfCommand() {
            super("df -i .", 2, 8);
        }
    }

    private static class AixDfCommand
    extends DfCommand {
        AixDfCommand() {
            super("df -i .", 2, 6);
        }
    }
}

