/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.model;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import io.jenkins.plugins.infisicaljenkins.model.InfisicalSecretValue;
import java.util.List;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class InfisicalSecret
extends AbstractDescribableImpl<InfisicalSecret> {
    private String path;
    private boolean includeImports;
    private List<InfisicalSecretValue> secretValues;

    @DataBoundConstructor
    public InfisicalSecret(String path, boolean includeImports, List<InfisicalSecretValue> secretValues) {
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        this.includeImports = includeImports;
        this.path = Util.fixEmptyAndTrim((String)path);
        if (this.path == null) {
            this.path = "/";
        }
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        this.secretValues = secretValues;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIncludeImports() {
        return this.includeImports;
    }

    public List<InfisicalSecretValue> getSecretValues() {
        return this.secretValues;
    }

    @Symbol(value={"infisicalSecret"})
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<InfisicalSecret> {
        public static final String DEFAULT_PATH = "/";
        public static final boolean DEFAULT_INCLUDE_IMPORTS = true;

        public String getDisplayName() {
            return "Infisical Secret";
        }
    }
}

