/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import io.jenkins.plugins.infisicaljenkins.InfisicalAccessor;
import io.jenkins.plugins.infisicaljenkins.configuration.InfisicalConfigResolver;
import io.jenkins.plugins.infisicaljenkins.configuration.InfisicalConfiguration;
import io.jenkins.plugins.infisicaljenkins.exception.InfisicalPluginException;
import io.jenkins.plugins.infisicaljenkins.log.MaskingConsoleLogFilter;
import io.jenkins.plugins.infisicaljenkins.model.InfisicalSecret;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InfisicalBuildWrapper
extends SimpleBuildWrapper {
    private InfisicalConfiguration configuration;
    private List<String> secretValuesToMask = new ArrayList<String>();
    protected transient PrintStream logger;
    private List<InfisicalSecret> infisicalSecrets;

    @DataBoundConstructor
    public InfisicalBuildWrapper(@CheckForNull List<InfisicalSecret> infisicalSecrets) {
        this.infisicalSecrets = infisicalSecrets;
    }

    @DataBoundSetter
    public void setConfiguration(InfisicalConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfisicalConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<InfisicalSecret> getInfisicalSecrets() {
        return this.infisicalSecrets;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) {
        this.logger = listener.getLogger();
        this.pullAndMergeConfiguration(build);
        if (this.infisicalSecrets != null) {
            this.provideEnvironmentVariablesFromInfisical(context, build, initialEnvironment);
        } else {
            this.logger.println("No secrets to fetch - skipping Infisical Plugin.");
        }
    }

    private void pullAndMergeConfiguration(Run<?, ?> build) {
        for (InfisicalConfigResolver resolver : ExtensionList.lookup(InfisicalConfigResolver.class)) {
            if (this.configuration != null) {
                this.configuration = this.configuration.mergeWithParent(resolver.forJob((Item)build.getParent()));
                continue;
            }
            this.configuration = resolver.forJob((Item)build.getParent());
        }
        if (this.configuration == null) {
            throw new InfisicalPluginException("No configuration found - please configure the Infisical Plugin.");
        }
        this.configuration.fixDefaults();
    }

    protected void provideEnvironmentVariablesFromInfisical(SimpleBuildWrapper.Context context, Run build, EnvVars envVars) {
        if (this.configuration == null) {
            throw new InfisicalPluginException("No configuration found - please configure the Infisical Plugin.");
        }
        if (this.infisicalSecrets == null) {
            throw new InfisicalPluginException("No secrets found - please configure the Infisical Plugin.");
        }
        Map<String, String> variables = new InfisicalAccessor().fetchInfisicalSecrets(build, this.logger, envVars, this.configuration, this.infisicalSecrets);
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            this.secretValuesToMask.add(entry.getValue());
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            context.env(entry.getKey(), entry.getValue());
        }
    }

    public ConsoleLogFilter createLoggerDecorator(@NonNull Run<?, ?> build) {
        return new MaskingConsoleLogFilter(build.getCharset().name(), this.secretValuesToMask);
    }

    @Symbol(value={"withInfisical"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(InfisicalBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Infisical Plugin";
        }
    }
}

