/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.infisicaljenkins.configuration.InfisicalConfiguration;
import io.jenkins.plugins.infisicaljenkins.credentials.AbstractAuthenticatingInfisicalTokenCredential;
import io.jenkins.plugins.infisicaljenkins.exception.InfisicalPluginException;
import io.jenkins.plugins.infisicaljenkins.infisical.InfisicalAuth;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InfisicalUniversalAuthCredential
extends AbstractAuthenticatingInfisicalTokenCredential {
    @NonNull
    private String machineIdentityClientId;
    @NonNull
    private String machineIdentityClientSecret;
    private final InfisicalAuth infisicalAuth = new InfisicalAuth();

    @DataBoundConstructor
    public InfisicalUniversalAuthCredential(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String machineIdentityClientId, @NonNull String machineIdentityClientSecret) {
        super(scope, id, description);
        this.machineIdentityClientId = machineIdentityClientId;
        this.machineIdentityClientSecret = machineIdentityClientSecret;
    }

    @NonNull
    public String getMachineIdentityClientId() {
        return this.machineIdentityClientId;
    }

    @NonNull
    public String getMachineIdentityClientSecret() {
        return this.machineIdentityClientSecret;
    }

    @DataBoundSetter
    public void setMachineIdentityClientId(String machineIdentityClientId) {
        this.machineIdentityClientId = machineIdentityClientId;
    }

    @DataBoundSetter
    public void setMachineIdentityClientSecret(String machineIdentityClientSecret) {
        this.machineIdentityClientSecret = machineIdentityClientSecret;
    }

    @Override
    public String getAccessToken(InfisicalConfiguration configuration) {
        try {
            return this.infisicalAuth.loginWithUniversalAuth(configuration.getInfisicalUrl(), this.machineIdentityClientId, this.machineIdentityClientSecret);
        }
        catch (InfisicalPluginException e) {
            throw new InfisicalPluginException("Failed to authenticate with Infisical", e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Infisical Universal Auth Credential";
        }
    }
}

