/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.credentials;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import io.jenkins.plugins.infisicaljenkins.credentials.InfisicalCredential;
import io.jenkins.plugins.infisicaljenkins.credentials.common.AbstractInfisicalBaseStandardCredentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

@Extension(optional=true, ordinal=1.0)
public class InfisicalCredentialsProvider
extends CredentialsProvider {
    public <C extends Credentials> List<C> getCredentials(Class<C> type, ItemGroup itemGroup, Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.emptyList());
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        CredentialsMatcher matcher = type != InfisicalCredential.class ? CredentialsMatchers.instanceOf(AbstractInfisicalBaseStandardCredentials.class) : CredentialsMatchers.always();
        ArrayList creds = new ArrayList();
        if (ACL.SYSTEM.equals((Object)authentication)) {
            ItemGroup g = itemGroup;
            while (g instanceof AbstractFolder) {
                FolderCredentialsProvider.FolderCredentialsProperty property = (FolderCredentialsProvider.FolderCredentialsProperty)((AbstractFolder)g).getProperties().get(FolderCredentialsProvider.FolderCredentialsProperty.class);
                if (property != null) {
                    List folderCreds = DomainCredentials.getCredentials((Map)property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
                    if (type != InfisicalCredential.class) {
                        for (Credentials c : folderCreds) {
                            ((AbstractInfisicalBaseStandardCredentials)c).setContext(g);
                        }
                    }
                    creds.addAll(folderCreds);
                }
                g = ((AbstractFolder)AbstractFolder.class.cast(g)).getParent();
            }
            List globalCreds = DomainCredentials.getCredentials((Map)SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
            if (type != InfisicalCredential.class) {
                for (Credentials c : globalCreds) {
                    ((AbstractInfisicalBaseStandardCredentials)c).setContext((ItemGroup)Jenkins.get());
                }
            }
            creds.addAll(globalCreds);
        }
        return creds;
    }
}

