/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.log;

import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;

public class MaskingConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String charsetName;
    private final List<String> valuesToMask;
    private Pattern pattern;
    private List<String> valuesToMaskInUse;

    public MaskingConsoleLogFilter(String charsetName, List<String> valuesToMask) {
        this.charsetName = charsetName;
        this.valuesToMask = valuesToMask;
        this.updatePattern();
    }

    private synchronized Pattern updatePattern() {
        if (!this.valuesToMask.equals(this.valuesToMaskInUse)) {
            List values = this.valuesToMask.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.pattern = values.isEmpty() ? null : SecretPatterns.getAggregateSecretPattern(values);
            this.valuesToMaskInUse = new ArrayList<String>(this.valuesToMask);
        }
        return this.pattern;
    }

    public OutputStream decorateLogger(Run run, OutputStream logger) throws IOException, InterruptedException {
        return new SecretPatterns.MaskingOutputStream(logger, this::updatePattern, this.charsetName);
    }
}

