/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.infisical;

import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import io.jenkins.plugins.infisicaljenkins.configuration.InfisicalConfiguration;
import io.jenkins.plugins.infisicaljenkins.credentials.InfisicalCredential;
import io.jenkins.plugins.infisicaljenkins.credentials.InfisicalLdapCredential;
import io.jenkins.plugins.infisicaljenkins.credentials.InfisicalUniversalAuthCredential;
import io.jenkins.plugins.infisicaljenkins.infisical.InfisicalSecrets;
import io.jenkins.plugins.infisicaljenkins.model.SingleSecretResponse;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Extension(optional=true)
public class InfisicalSecretSource
extends SecretSource {
    private static final Logger LOGGER = Logger.getLogger(InfisicalSecretSource.class.getName());
    private static final String CASC_INFISICAL_ENVIRONMENT_SLUG = "CASC_INFISICAL_ENVIRONMENT_SLUG";
    private static final String CASC_INFISICAL_FILE = "CASC_INFISICAL_FILE";
    private static final String CASC_INFISICAL_INCLUDE_IMPORTS = "CASC_INFISICAL_INCLUDE_IMPORTS";
    private static final String CASC_INFISICAL_PROJECT_SLUG = "CASC_INFISICAL_PROJECT_SLUG";
    private static final String CASC_INFISICAL_SECRETPATH = "CASC_INFISICAL_SECRETPATH";
    private static final String CASC_INFISICAL_URL = "CASC_INFISICAL_URL";
    private static final String CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_ID = "CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_ID";
    private static final String CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_SECRET = "CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_SECRET";
    private static final String CASC_INFISICAL_LDAP_IDENTITY_ID = "CASC_INFISICAL_LDAP_IDENTITY_ID";
    private static final String CASC_INFISICAL_LDAP_USER = "CASC_INFISICAL_LDAP_USER";
    private static final String CASC_INFISICAL_LDAP_PW = "CASC_INFISICAL_LDAP_PW";
    private InfisicalCredential credential;
    private List<SingleSecretResponse> secrets;
    private InfisicalConfiguration configuration;
    private Properties prop;
    private static final String CREDENTIALS_ID = "LDAP_Credential_for_PCASC";

    public void init() {
        this.prop = new Properties();
        Optional<String> propsFile = Optional.ofNullable(System.getenv(CASC_INFISICAL_FILE));
        propsFile.ifPresent(this::readPropertiesFromFile);
        Optional<String> ldapIdentityId = this.getVariable(CASC_INFISICAL_LDAP_IDENTITY_ID);
        Optional<String> ldapUser = this.getVariable(CASC_INFISICAL_LDAP_USER);
        Optional<String> ldapPw = this.getVariable(CASC_INFISICAL_LDAP_PW);
        Optional<String> machineIdentityClientId = this.getVariable(CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_ID);
        Optional<String> machineIdentityClientSecret = this.getVariable(CASC_INFISICAL_MACHINE_IDENTITY_CLIENT_SECRET);
        Optional<String> environmentSlug = this.getVariable(CASC_INFISICAL_ENVIRONMENT_SLUG);
        Optional<String> infisicalUrl = this.getVariable(CASC_INFISICAL_URL);
        Optional<String> includeImports = this.getVariable(CASC_INFISICAL_INCLUDE_IMPORTS);
        Optional<String> projectSlug = this.getVariable(CASC_INFISICAL_PROJECT_SLUG);
        Optional<String> secretPath = this.getVariable(CASC_INFISICAL_SECRETPATH);
        CredentialsScope scope = CredentialsScope.SYSTEM;
        this.credential = null;
        if (environmentSlug.isEmpty() || projectSlug.isEmpty()) {
            LOGGER.info("Configuration missing.  Not using Infisical to perform PCasC variable lookup.");
            return;
        }
        if (ldapIdentityId.isPresent() && ldapUser.isPresent() && ldapPw.isPresent()) {
            LOGGER.info("Using LDAP credentials");
            this.credential = new InfisicalLdapCredential(scope, CREDENTIALS_ID, "LDAP Credential for PCASC", ldapIdentityId.get(), ldapUser.get(), ldapPw.get());
        } else if (machineIdentityClientId.isPresent() && machineIdentityClientSecret.isPresent()) {
            LOGGER.info("Using Universal Auth credentials");
            this.credential = new InfisicalUniversalAuthCredential(scope, CREDENTIALS_ID, "LDAP Credential for PCASC", machineIdentityClientId.get(), machineIdentityClientSecret.get());
        } else {
            LOGGER.info("No credentials found.  Not using Infisical to perform PCasC variable lookup.");
            return;
        }
        this.configuration = new InfisicalConfiguration();
        this.configuration.setInfisicalCredentialId(CREDENTIALS_ID);
        this.configuration.setInfisicalUrl(infisicalUrl.orElse(null));
        this.configuration.setInfisicalProjectSlug(projectSlug.get());
        this.configuration.setInfisicalEnvironmentSlug(environmentSlug.get());
        this.retrieveSecrets(secretPath.orElse("/"), Boolean.parseBoolean(includeImports.orElse("false")));
    }

    private void retrieveSecrets(String secretPath, boolean includeImports) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);
        this.secrets = InfisicalSecrets.getSecrets(this.configuration, this.credential, secretPath, includeImports, ps);
        ps.flush();
        LOGGER.info(baos.toString(StandardCharsets.UTF_8));
        ps.close();
    }

    private Optional<String> getVariable(String key) {
        return Optional.ofNullable(this.prop.getProperty(key, System.getenv(key)));
    }

    private void readPropertiesFromFile(String propsFile) {
        try (FileInputStream input = new FileInputStream(propsFile);){
            this.prop.load(input);
            if (this.prop.isEmpty()) {
                LOGGER.log(Level.WARNING, "Infisical properties file is empty");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load Infisical properties from file", e);
        }
    }

    public Optional<String> reveal(String secret) {
        if (StringUtils.isBlank((String)secret)) {
            return Optional.empty();
        }
        if (this.configuration == null) {
            return Optional.empty();
        }
        try {
            this.configuration.fixDefaults();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to prepare Infisical configuration for JCasC", e);
            return Optional.empty();
        }
        try {
            if (this.secrets == null || this.secrets.isEmpty()) {
                return Optional.empty();
            }
            for (SingleSecretResponse s : this.secrets) {
                if (!secret.equals(s.getSecretKey())) continue;
                return Optional.ofNullable(s.getSecretValue());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to reveal Infisical secret for JCasC", e);
            return Optional.empty();
        }
    }
}

