/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.infisical;

import io.jenkins.plugins.infisicaljenkins.exception.InfisicalPluginException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class InfisicalAuth
implements Serializable {
    public String loginWithLdapAuth(String infisicalUrl, String identityId, String username, String password) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(infisicalUrl + "/api/v1/auth/ldap-auth/login");
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("identityId", (Object)identityId);
            jsonBody.put("username", (Object)username);
            jsonBody.put("password", (Object)password);
            String jsonInputString = jsonBody.toString();
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(jsonInputString.getBytes(StandardCharsets.UTF_8));
            }
            String accessToken = this.getTokenFromConnection(connection);
            String string = String.format("Bearer %s", accessToken);
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InfisicalPluginException(ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public String loginWithUniversalAuth(String infisicalUrl, String machineIdentityClientId, String machineIdentityClientSecret) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(infisicalUrl + "/api/v1/auth/universal-auth/login");
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("clientId", (Object)machineIdentityClientId);
            jsonBody.put("clientSecret", (Object)machineIdentityClientSecret);
            String jsonInputString = jsonBody.toString();
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(jsonInputString.getBytes(StandardCharsets.UTF_8));
            }
            String accessToken = this.getTokenFromConnection(connection);
            String string = String.format("Bearer %s", accessToken);
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InfisicalPluginException(ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getTokenFromConnection(HttpURLConnection connection) throws InfisicalPluginException, IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JSONObject jsonResponse = new JSONObject(response.toString());
            return jsonResponse.getString("accessToken");
        }
        throw new InfisicalPluginException("Failed to authenticate with Infisical. Response code: " + responseCode);
    }

    public void revoke(String infisicalUrl, String token) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(infisicalUrl + "/api/v1/auth/token/revoke");
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InfisicalPluginException(ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

