/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.infisicaljenkins.infisical;

import com.google.gson.Gson;
import io.jenkins.plugins.infisicaljenkins.configuration.InfisicalConfiguration;
import io.jenkins.plugins.infisicaljenkins.credentials.InfisicalCredential;
import io.jenkins.plugins.infisicaljenkins.exception.InfisicalPluginException;
import io.jenkins.plugins.infisicaljenkins.model.SecretResponseWrapper;
import io.jenkins.plugins.infisicaljenkins.model.SingleImportResponse;
import io.jenkins.plugins.infisicaljenkins.model.SingleSecretResponse;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class InfisicalSecrets
implements Serializable {
    public static List<SingleSecretResponse> getSecrets(InfisicalConfiguration configuration, InfisicalCredential credential, String secretPath, boolean includeImports, boolean recursive, PrintStream logger) {
        String accessToken;
        HttpURLConnection connection = null;
        try {
            accessToken = credential.getAccessToken(configuration);
        }
        catch (InfisicalPluginException e) {
            throw new InfisicalPluginException("Failed to authenticate with Infisical", e);
        }
        try {
            String urlString = String.format("%s%s?secretPath=%s&workspaceSlug=%s&environment=%s&expandSecretReferences=true&include_imports=%s&recursive=%s", configuration.getInfisicalUrl(), "/api/v3/secrets/raw", URLEncoder.encode(secretPath, "UTF-8"), configuration.getInfisicalProjectSlug(), configuration.getInfisicalEnvironmentSlug(), includeImports ? "true" : "false", recursive ? "true" : "false");
            logger.println("Fetching secrets from Infisical at: " + urlString);
            URL url = new URL(urlString);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Authorization", accessToken);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Gson gson = new Gson();
                SecretResponseWrapper response = (SecretResponseWrapper)gson.fromJson((Reader)new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8), SecretResponseWrapper.class);
                if (response == null) {
                    throw new InfisicalPluginException("Failed to fetch secrets from Infisical, got null response");
                }
                List<SingleImportResponse> imports = response.getImports();
                List<SingleSecretResponse> secrets = response.getSecrets();
                if (secrets == null || includeImports && imports == null) {
                    throw new InfisicalPluginException("Failed to fetch secrets from Infisical, secrets and/or imports are null");
                }
                if (includeImports && imports != null && !imports.isEmpty()) {
                    imports.forEach(importedSecret -> {
                        try {
                            List<SingleSecretResponse> importedSecrets = importedSecret.getSecrets();
                            importedSecrets.forEach(importedSecretResponse -> {
                                if (secrets.stream().anyMatch(secret -> secret.getSecretKey().equals(importedSecretResponse.getSecretKey()))) {
                                    secrets.removeIf(secret -> secret.getSecretKey().equals(importedSecretResponse.getSecretKey()));
                                }
                                secrets.add((SingleSecretResponse)importedSecretResponse);
                            });
                        }
                        catch (InfisicalPluginException e) {
                            throw new InfisicalPluginException("Failed to fetch imported secrets from Infisical", e);
                        }
                    });
                }
                List<SingleSecretResponse> list = secrets;
                return list;
            }
            try {
                throw new InfisicalPluginException("Failed to fetch secrets. HTTP error code: " + responseCode);
            }
            catch (IOException ex) {
                throw new InfisicalPluginException("Failed to read secrets from Infisical", ex);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

